<?php

namespace App\Repositories\Master;

use App\Http\Requests\Master\SOPPolicyListRequest;
use App\Http\Requests\Master\SOPPolicyAddRequest;

use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\Master\MasterSOPPolicyServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\Master\MasterSOPPolicyResource;
use App\Models\UserMapRole;

class MasterSOPPolicyRepository implements MasterSOPPolicyInterface
{
    use EncDecService;
    public $vvsMasterSOPPolicyService;
    public $vvsSOPPolicyListRequest;
    public $vvsSOPPolicyAddRequest;
    public $vvsUserService;

    /**
     * MasterSkillRepository constructor.
     */

    public function __construct()
    {
        $this->vvsMasterSOPPolicyService = new MasterSOPPolicyServices();
        $this->vvsSOPPolicyListRequest = new SOPPolicyListRequest();
        $this->vvsSOPPolicyAddRequest = new SOPPolicyAddRequest();
        $this->vvsUserService = new UserServices();
    }

    /**
     * @param Request $request
     * @return MasterSOPPolicyResource
     */
    public function listSOPPolicy(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsMasterUerRoleData = $vvsUserData->masterroles;
            $vvsUserRole = "";
            if (isset($vvsMasterUerRoleData) && !empty($vvsMasterUerRoleData) && isset($vvsMasterUerRoleData[0])) {
                $vvsUserRole = $vvsMasterUerRoleData[0]->ROLE_ID;
            }
            $validationErrorData = $this->vvsSOPPolicyListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsMasterSOPPolicyData = $this->vvsMasterSOPPolicyService->getMasterSOPPolicylList($requestData);
                $masterSOPPolicyTotalCount = $vvsMasterSOPPolicyData['total'];
                foreach ($vvsMasterSOPPolicyData['data'] as $location) {
                    $location->UserRole = $vvsUserRole;
                }
                $masterSOPPolicyList = MasterSOPPolicyResource::collection($vvsMasterSOPPolicyData['data']);
                
                $output = ["SOPPolicy_LIST" => $masterSOPPolicyList,"TOTAL_NO" => $masterSOPPolicyTotalCount];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return MasterSOPPolicyResource
     */
    public function sopPolicyAdd(Request $request)
    {
        if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
            return $this->failureMessage("Request pattern is not valid.");
        }
        $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
        if (!$vvsUserData->toArray()) {
            return $this->failureMessage("Invalid User Id");
        }
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsMasterUerRoleData = $vvsUserData->masterroles;
            $vvsUserRole = "";
            if (isset($vvsMasterUerRoleData) && !empty($vvsMasterUerRoleData) && isset($vvsMasterUerRoleData[0])) {
                $vvsUserRole = $vvsMasterUerRoleData[0]->ROLE_ID;
            }
            $validationErrorData = "";
            $validationErrorData = $request->SOPPolicyAddValidation();
            if (trim($validationErrorData) === "") {
                $sopDataSaved = $this->vvsMasterSOPPolicyService->sopPolicyAdd($requestData, $vvsUserRole);
                return $this->successMessage($sopDataSaved);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return MasterSOPPolicyResource
     */
    public function sopPolicyDetails(Request $request)
    {
        if (!isset($request->X_KEY) || empty($request->CREATED_BY)) {
            return $this->failureMessage("Request pattern is not valid.");
        }
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $errorMessage = "";
            if (!$vvsUserData->toArray()) {
                $errorMessage = "Token mismatch";
            } else {
                $vvsSOPData = $this->vvsMasterSOPPolicyService->getSOPPolicyDetails($requestData);
                $vvsPtwMstSoapPoliciesTableOutput = MasterSOPPolicyResource::transformSOP($vvsSOPData);
                return $this->successMessage($vvsPtwMstSoapPoliciesTableOutput);
            }
            return $this->failureMessage($errorMessage);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}