<?php

namespace App\Repositories\Master;

use App\Http\Requests\Master\RiskRelatedListRequest;
use App\Http\Requests\Master\RiskRelatedAddRequest;

use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\Master\MasterRiskRelatedServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\Master\MasterRiskRelatedResource;
use App\Models\UserMapRole;

class MasterRiskRelatedRepository implements MasterRiskRelatedInterface
{
    use EncDecService;
    public $vvsMasterRiskRelatedServices;
    public $vvsRiskRelatedListRequest;
    public $vvsRiskRelatedAddRequest;
    public $vvsUserService;

    /**
     * MasterRiskRelatedRepository constructor.
     */

    public function __construct()
    {
        $this->vvsMasterRiskRelatedServices = new MasterRiskRelatedServices();
        $this->vvsRiskRelatedListRequest = new RiskRelatedListRequest();
        $this->vvsRiskRelatedAddRequest = new RiskRelatedAddRequest();
        $this->vvsUserService = new UserServices();
    }

    /**
     * @param Request $request
     * @return MasterRiskRelatedResource
     */
    public function listRiskRelated(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsMasterUerRoleData = $vvsUserData->masterroles;
            $vvsUserRole = "";
            if (isset($vvsMasterUerRoleData) && !empty($vvsMasterUerRoleData) && isset($vvsMasterUerRoleData[0])) {
                $vvsUserRole = $vvsMasterUerRoleData[0]->ROLE_ID;
            }
            $validationErrorData = $this->vvsRiskRelatedListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsMasterRiskRelatedData = $this->vvsMasterRiskRelatedServices->getMasterRiskRelatedList($requestData);
                $masterRiskRelatedTotalCount = $vvsMasterRiskRelatedData['total'];
                $riskRelatedIdsFromHira = $this->vvsMasterRiskRelatedServices->getRiskRelatedIdsFromHira();
                
                foreach ($vvsMasterRiskRelatedData['data'] as $riskRelatedData) {
                    $riskRelatedId = $riskRelatedData->RISK_RELATED_ID;
                    $riskRelatedIdsFromHiraArray = $riskRelatedIdsFromHira->toArray();
                    $riskRelatedData->RiskRelatedInUse = (in_array($riskRelatedId, $riskRelatedIdsFromHiraArray)) ? 1 : 0;
                }
                
                $masterRiskRelatedList = MasterRiskRelatedResource::collection($vvsMasterRiskRelatedData['data']);
                
                $output = ["RISK_RELATED_LIST" => $masterRiskRelatedList,"TOTAL_NO" => $masterRiskRelatedTotalCount];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return MasterRiskRelatedResource
     */
    public function riskRelatedAdd(Request $request)
    {
        if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
            return $this->failureMessage("Request pattern is not valid.");
        }
        $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
        if (!$vvsUserData->toArray()) {
            return $this->failureMessage("Invalid User Id");
        }
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsMasterUerRoleData = $vvsUserData->masterroles;
            $vvsUserRole = "";
            if (isset($vvsMasterUerRoleData) && !empty($vvsMasterUerRoleData) && isset($vvsMasterUerRoleData[0])) {
                $vvsUserRole = $vvsMasterUerRoleData[0]->ROLE_ID;
            }
            $validationErrorData = "";
            $validationErrorData = $request->riskRelatedAddValidation();
            if (trim($validationErrorData) === "") {
                $riskRelatedDataSaved = $this->vvsMasterRiskRelatedServices->riskRelatedSave($requestData, $vvsUserRole);
                return $this->successMessage($riskRelatedDataSaved);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return MasterRiskRelatedResource
     */
    public function riskRelatedDetails(Request $request)
    {
        if (!isset($request->X_KEY) || empty($request->CREATED_BY)) {
            return $this->failureMessage("Request pattern is not valid.");
        }
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $errorMessage = "";
            if (!$vvsUserData->toArray()) {
                $errorMessage = "Token mismatch";
            } else {
                $vvsRiskRelatedData = $this->vvsMasterRiskRelatedServices->getRiskRelatedDetails($requestData);
                $vvsHiraMstRiskRelatedTableOutput = MasterRiskRelatedResource::transformRiskRelated($vvsRiskRelatedData);
                return $this->successMessage($vvsHiraMstRiskRelatedTableOutput);
            }
            return $this->failureMessage($errorMessage);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}