<?php

namespace App\Repositories\Master;

use App\Http\Requests\Master\LocationListRequest;
use App\Http\Requests\Master\LocationAddRequest;

use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\Master\MasterLocationServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\Master\MasterLocationResource;
// use App\Repositories\Master\MasterWorkerFileProcess;
use App\Models\UserMapRole;

class MasterLocationRepository implements MasterLocationInterface
{
    use EncDecService;
    public $vvsMasterLocationService;
    public $vvsLocationListRequest;
    public $vvsLocationAddRequest;
    public $vvsUserService;

    /**
     * MasterLocationRepository constructor.
     */

    public function __construct()
    {
        $this->vvsMasterLocationService = new MasterLocationServices();
        $this->vvsLocationListRequest = new LocationListRequest();
        $this->vvsLocationAddRequest = new LocationAddRequest();
        $this->vvsUserService = new UserServices();
        // $this->vvsWorkerFileProcess = new MasterWorkerFileProcess();
    }

    /**
     * @param Request $request
     * @return MasterLocationResource
     */
    public function listLocation(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsMasterUerRoleData = $vvsUserData->masterroles;
            $vvsUserRole = "";
            if (isset($vvsMasterUerRoleData) && !empty($vvsMasterUerRoleData) && isset($vvsMasterUerRoleData[0])) {
                $vvsUserRole = $vvsMasterUerRoleData[0]->ROLE_ID;
            }
            $validationErrorData = $this->vvsLocationListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsMasterLocationData = $this->vvsMasterLocationService->getMasterLocationList($requestData);
                $masterLocationTotalCount = $vvsMasterLocationData['total'];
                foreach ($vvsMasterLocationData['data'] as $location) {
                    $location->UserRole = $vvsUserRole;
                }
                $masterLocationList = MasterLocationResource::collection($vvsMasterLocationData['data']);
                
                $output = ["LOCATION_LIST" => $masterLocationList,"TOTAL_NO" => $masterLocationTotalCount];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return MasterLocationResource
     */
    public function locationAdd(Request $request)
    {
        if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
            return $this->failureMessage("Request pattern is not valid.");
        }
        $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
        if (!$vvsUserData->toArray()) {
            return $this->failureMessage("Invalid User Id");
        }
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsMasterUerRoleData = $vvsUserData->masterroles;
            $vvsUserRole = "";
            if (isset($vvsMasterUerRoleData) && !empty($vvsMasterUerRoleData) && isset($vvsMasterUerRoleData[0])) {
                $vvsUserRole = $vvsMasterUerRoleData[0]->ROLE_ID;
            }
            $validationErrorData = "";
            // $validationErrorData = $this->vvsLocationAddRequest->locationAddValidation($requestData);
            $validationErrorData = $request->locationAddValidation();
            if (trim($validationErrorData) === "") {
                $locationDataSaved = $this->vvsMasterLocationService->locationSave($requestData, $vvsUserRole);
                return $this->successMessage($locationDataSaved);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return MasterLocationResource
     */
    public function locationDetails(Request $request)
    {
        if (!isset($request->X_KEY) || empty($request->CREATED_BY)) {
            return $this->failureMessage("Request pattern is not valid.");
        }
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $errorMessage = "";
            if (!$vvsUserData->toArray()) {
                $errorMessage = "Token mismatch";
            } else {
                $vvsLocationData = $this->vvsMasterLocationService->getLocationDetails($requestData);
                $vvsMstLocationTableOutput = MasterLocationResource::transformLocation($vvsLocationData);
                return $this->successMessage($vvsMstLocationTableOutput);
            }
            return $this->failureMessage($errorMessage);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}