<?php

namespace App\Repositories\Master;

use App\Http\Requests\Master\JobListRequest;
use App\Http\Requests\Master\JobAddRequest;

use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\Master\MasterJobServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\Master\MasterJobResource;
use App\Models\UserMapRole;

class MasterJobRepository implements MasterJobInterface
{
    use EncDecService;
    public $vvsMasterJobService;
    public $vvsJobListRequest;
    public $vvsJobAddRequest;
    public $vvsUserService;

    /**
     * MasterJobRepository constructor.
     */

    public function __construct()
    {
        $this->vvsMasterJobService = new MasterJobServices();
        $this->vvsJobListRequest = new JobListRequest();
        $this->vvsJobAddRequest = new JobAddRequest();
        $this->vvsUserService = new UserServices();
    }

    /**
     * @param Request $request
     * @return MasterJobResource
     */
    public function listJob(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsMasterUerRoleData = $vvsUserData->masterroles;
            $vvsUserRole = "";
            if (isset($vvsMasterUerRoleData) && !empty($vvsMasterUerRoleData) && isset($vvsMasterUerRoleData[0])) {
                $vvsUserRole = $vvsMasterUerRoleData[0]->ROLE_ID;
            }
            $validationErrorData = $this->vvsJobListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsMasterJobData = $this->vvsMasterJobService->getMasterJobList($requestData);
                $masterJobTotalCount = $vvsMasterJobData['total'];
                $jobIdsFromHira = $this->vvsMasterJobService->getJobIdsFromHira();
                $jobIdsFromActivity = $this->vvsMasterJobService->getJobIdsFromActivity();
                
                foreach ($vvsMasterJobData['data'] as $jobData) {
                    $jobId = $jobData->JOB_ID;
                    $jobIdsFromHiraArray = $jobIdsFromHira->toArray();
                    $jobIdsFromActivityArray = $jobIdsFromActivity->toArray();
                    $jobData->JobInUse = (in_array($jobId, $jobIdsFromHiraArray) ||
                                     in_array($jobId, $jobIdsFromActivityArray)) ? 1 : 0;
                }
                
                $masterJobList = MasterJobResource::collection($vvsMasterJobData['data']);
                
                $output = ["JOB_LIST" => $masterJobList,"TOTAL_NO" => $masterJobTotalCount];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return MasterJobResource
     */
    public function jobAdd(Request $request)
    {
        if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
            return $this->failureMessage("Request pattern is not valid.");
        }
        $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
        if (!$vvsUserData->toArray()) {
            return $this->failureMessage("Invalid User Id");
        }
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsMasterUerRoleData = $vvsUserData->masterroles;
            $vvsUserRole = "";
            if (isset($vvsMasterUerRoleData) && !empty($vvsMasterUerRoleData) && isset($vvsMasterUerRoleData[0])) {
                $vvsUserRole = $vvsMasterUerRoleData[0]->ROLE_ID;
            }
            $validationErrorData = "";
            $validationErrorData = $request->jobAddValidation();
            if (trim($validationErrorData) === "") {
                $jobDataSaved = $this->vvsMasterJobService->jobSave($requestData, $vvsUserRole);
                return $this->successMessage($jobDataSaved);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return MasterJobResource
     */
    public function jobDetails(Request $request)
    {
        if (!isset($request->X_KEY) || empty($request->CREATED_BY)) {
            return $this->failureMessage("Request pattern is not valid.");
        }
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $errorMessage = "";
            if (!$vvsUserData->toArray()) {
                $errorMessage = "Token mismatch";
            } else {
                $vvsJobData = $this->vvsMasterJobService->getJobDetails($requestData);
                $vvsHiraMstJobTableOutput = MasterJobResource::transformJob($vvsJobData);
                return $this->successMessage($vvsHiraMstJobTableOutput);
            }
            return $this->failureMessage($errorMessage);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}