<?php

namespace App\Repositories\Master;

use App\Http\Requests\Master\ContractorListRequest;
use App\Http\Requests\Master\ContractorAddRequest;

use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\Master\MasterContractorServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\Master\MasterContractorResource;
use App\Models\UserMapRole;

class MasterContractorRepository implements MasterContractorInterface
{
    use EncDecService;
    public $vvsMasterContractorService;
    public $vvsContractorListRequest;
    public $vvsContractorAddRequest;
    public $vvsUserService;

    /**
     * MasterContractorRepository constructor.
     */

    public function __construct()
    {
        $this->vvsMasterContractorService = new MasterContractorServices();
        $this->vvsContractorListRequest = new ContractorListRequest();
        $this->vvsContractorAddRequest = new ContractorAddRequest();
        $this->vvsUserService = new UserServices();
    }

    /**
     * @param Request $request
     * @return MasterContractorResource
     */
    public function listContractor(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsMasterUerRoleData = $vvsUserData->masterroles;
            $vvsUserRole = "";
            if (isset($vvsMasterUerRoleData) && !empty($vvsMasterUerRoleData) && isset($vvsMasterUerRoleData[0])) {
                $vvsUserRole = $vvsMasterUerRoleData[0]->ROLE_ID;
            }
            $validationErrorData = $this->vvsContractorListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsMasterContractorData = $this->vvsMasterContractorService->getMasterContractorList($requestData);
                $masterContractorTotalCount = $vvsMasterContractorData['total'];
                foreach ($vvsMasterContractorData['data'] as $location) {
                    $location->UserRole = $vvsUserRole;
                }
                $masterContractorList = MasterContractorResource::collection($vvsMasterContractorData['data']);
                
                $output = ["CONTRACTOR_LIST" => $masterContractorList,"TOTAL_NO" => $masterContractorTotalCount];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return MasterContractorResource
     */
    public function contractorAdd(Request $request)
    {
        if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
            return $this->failureMessage("Request pattern is not valid.");
        }
        $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
        if (!$vvsUserData->toArray()) {
            return $this->failureMessage("Invalid User Id");
        }
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsMasterUerRoleData = $vvsUserData->masterroles;
            $vvsUserRole = "";
            if (isset($vvsMasterUerRoleData) && !empty($vvsMasterUerRoleData) && isset($vvsMasterUerRoleData[0])) {
                $vvsUserRole = $vvsMasterUerRoleData[0]->ROLE_ID;
            }
            $validationErrorData = "";
            $validationErrorData = $request->contractorAddValidation();
            if (trim($validationErrorData) === "") {
                $contractorDataSaved = $this->vvsMasterContractorService->contractorSave($requestData, $vvsUserRole);
                return $this->successMessage($contractorDataSaved);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return MasterContractorResource
     */
    public function contractorDetails(Request $request)
    {
        if (!isset($request->X_KEY) || empty($request->CREATED_BY)) {
            return $this->failureMessage("Request pattern is not valid.");
        }
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $errorMessage = "";
            if (!$vvsUserData->toArray()) {
                $errorMessage = "Token mismatch";
            } else {
                $vvsContractorData = $this->vvsMasterContractorService->getContractorDetails($requestData);
                $vvsPtwMstContractorTableOutput = MasterContractorResource::transformContractor($vvsContractorData);
                return $this->successMessage($vvsPtwMstContractorTableOutput);
            }
            return $this->failureMessage($errorMessage);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}