<?php

namespace App\Repositories\Master;

use App\Http\Requests\Master\ActivityListRequest;
use App\Http\Requests\Master\ActivityAddRequest;

use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\Master\MasterActivityServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\Master\MasterActivityResource;
use App\Models\UserMapRole;

class MasterActivityRepository implements MasterActivityInterface
{
    use EncDecService;
    public $vvsMasterActivityServices;
    public $vvsActivityListRequest;
    public $vvsActivityAddRequest;
    public $vvsUserService;

    /**
     * MasterActivityRepository constructor.
     */

    public function __construct()
    {
        $this->vvsMasterActivityServices = new MasterActivityServices();
        $this->vvsActivityListRequest = new ActivityListRequest();
        $this->vvsActivityAddRequest = new ActivityAddRequest();
        $this->vvsUserService = new UserServices();
    }

    /**
     * @param Request $request
     * @return MasterActivityResource
     */
    public function listActivity(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsMasterUerRoleData = $vvsUserData->masterroles;
            $vvsUserRole = "";
            if (isset($vvsMasterUerRoleData) && !empty($vvsMasterUerRoleData) && isset($vvsMasterUerRoleData[0])) {
                $vvsUserRole = $vvsMasterUerRoleData[0]->ROLE_ID;
            }
            $validationErrorData = $this->vvsActivityListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsMasterActivityData = $this->vvsMasterActivityServices->getMasterActivityList($requestData);
                $masterActivityTotalCount = $vvsMasterActivityData['total'];
                $activityIdsFromHira = $this->vvsMasterActivityServices->getActivityIdsFromHira();
                $activityIdsFromRisk = $this->vvsMasterActivityServices->getActivityIdsFromRisk();
                
                foreach ($vvsMasterActivityData['data'] as $activityData) {
                    $activityId = $activityData->ACTIVITY_ID;
                    $activityIdsFromHiraArray = $activityIdsFromHira->toArray();
                    $activityIdsFromRiskArray = $activityIdsFromRisk->toArray();
                    $activityData->ActivityInUse = (in_array($activityId, $activityIdsFromHiraArray) ||
                                     in_array($activityId, $activityIdsFromRiskArray)) ? 1 : 0;
                }
                
                $masterActivityList = MasterActivityResource::collection($vvsMasterActivityData['data']);
                
                $output = ["ACTIVITY_LIST" => $masterActivityList,"TOTAL_NO" => $masterActivityTotalCount];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return MasterActivityResource
     */
    public function activityAdd(Request $request)
    {
        if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
            return $this->failureMessage("Request pattern is not valid.");
        }
        $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
        if (!$vvsUserData->toArray()) {
            return $this->failureMessage("Invalid User Id");
        }
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsMasterUerRoleData = $vvsUserData->masterroles;
            $vvsUserRole = "";
            if (isset($vvsMasterUerRoleData) && !empty($vvsMasterUerRoleData) && isset($vvsMasterUerRoleData[0])) {
                $vvsUserRole = $vvsMasterUerRoleData[0]->ROLE_ID;
            }
            $validationErrorData = "";
            $validationErrorData = $request->activityAddValidation();
            if (trim($validationErrorData) === "") {
                $activityDataSaved = $this->vvsMasterActivityServices->activitySave($requestData, $vvsUserRole);
                return $this->successMessage($activityDataSaved);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return MasterActivityResource
     */
    public function activityDetails(Request $request)
    {
        if (!isset($request->X_KEY) || empty($request->CREATED_BY)) {
            return $this->failureMessage("Request pattern is not valid.");
        }
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $errorMessage = "";
            if (!$vvsUserData->toArray()) {
                $errorMessage = "Token mismatch";
            } else {
                $vvsActivityData = $this->vvsMasterActivityServices->getActivityDetails($requestData);
                $vvsHiraMstActivityTableOutput = MasterActivityResource::transformActivity($vvsActivityData);
                return $this->successMessage($vvsHiraMstActivityTableOutput);
            }
            return $this->failureMessage($errorMessage);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}