<?php

namespace App\Repositories\INSPECTION;

use App\Http\Requests\INSPECTION\InspectionListRequest;
use App\Http\Requests\INSPECTION\ViewRequest;
use App\Http\Requests\INSPECTION\AddRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

use App\Http\Traits\EncDecService;
use App\Services\INSPECTION\InspectionServices;
use App\Services\INSPECTION\InspectionActivityServices;
use App\Services\INSPECTION\InspectionMstDeclarationServices;
use App\Services\INSPECTION\InspectionActionHistoryServices;
use App\Services\INSPECTION\InspectionCheckListServices;
use App\Repositories\INSPECTION\InspectionFileProcess;

use App\Services\UserServices;

use App\Models\MstLocation;

use App\Http\Resources\INSPECTION\InspectionResource;
use App\Http\Resources\INSPECTION\InspectionMstDeclarationResource;
use App\Http\Resources\INSPECTION\InspectionMapDeclarationResource;
use App\Http\Resources\INSPECTION\InspectionMapCheckListResource;
use App\Http\Resources\INSPECTION\InspectionActionHistoryResource;

class InspectionRepository implements InspectionInterface
{
    use EncDecService;
    public $vvsInspectionListRequest;
    public $vvsInspectionService;
    public $vvsInspectionAddRequest;
    public $vvsInspectionDeclService;
    public $vvsInspectionViewRequest;
    public $vvsUserService;
    public $vvsInspectionActivityService;    
    public $vvsInspectionActivityLogService;
    public $vvsInspectionCheckListService;
    public $vvsInspectionFileProcess;


    public function __construct()
    {
        $this->vvsUserService = new UserServices();
        $this->vvsInspectionListRequest = new InspectionListRequest(); 
        $this->vvsInspectionViewRequest = new ViewRequest();
        $this->vvsInspectionAddRequest = new AddRequest();
        $this->vvsInspectionFileProcess = new InspectionFileProcess();       
        $this->vvsInspectionService = new InspectionServices();        
        $this->vvsInspectionDeclService = new InspectionMstDeclarationServices();
        $this->vvsInspectionActivityLogService = new InspectionActionHistoryServices();
        $this->vvsInspectionCheckListService = new InspectionCheckListServices();   
    }

    public function listInspection(Request $request){
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsInspectionUerRoleData = $vvsUserData->inspectionroles;
            $vvsUserRole = "";
            if(isset($vvsInspectionUerRoleData) && !empty($vvsInspectionUerRoleData)){
                $vvsUserRole = $vvsInspectionUerRoleData[0]->ROLE_ID;
            }            
            $validationErrorData = $this->vvsInspectionListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsInspectionData = $this->vvsInspectionService->getInspectionList($requestData);
                $InspectionTotalCount = $this->vvsInspectionService->getInspectionListTotalCount($requestData);
                $InspectionList = InspectionResource::collection($vvsInspectionData);
                $calculatedTab = $this->vvsInspectionService->calculatedTab($requestData);
                $output = ["TAB" => $calculatedTab, "INSPECTION_LIST" => $InspectionList,"TOTAL_NO" => $InspectionTotalCount,
                            "IS_ADD_BTN"=>(($vvsUserRole == 7)?true:false)];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

   /**
     * @param Request $request
     * @return InspectionResource
     */
    public function inspectionAdd(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
         
            //checking role access for action
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
           
            $roleIds = array_map(function($item) {
                                    return $item['ROLE_ID'];
                                }, $vvsUserData ->Inspectionroles->toArray());
            if(in_array(7,$roleIds) && !in_array(strtoupper($requestData->ACTION),["DRAFT","SAVE","REQUEST_FOR_CLOSURE","REQUEST_FOR_SUSPEND","RENEW"])){
                return $this->failureMessage("Sorry! You are not permitted to create a Inspection.");
            }
            if(in_array(8,$roleIds) && !in_array(strtoupper($requestData->ACTION),["MOVE_FORWARD","SEND_BACK","CLOSE","SUSPEND"])){
                return $this->failureMessage("Sorry! You are not permitted to take the selected action.");
            }
            if(in_array(9,$roleIds) && !in_array(strtoupper($requestData->ACTION),["APPROVE","REJECT"])){
                return $this->failureMessage("Sorry! You are not permitted to take the selected action.");
            }
            

            //forcefully sending action irrespective of stage
                //ntbd
           
            if(in_array(strtoupper($requestData->ACTION),["DRAFT","SAVE"])){

                $vvsInspectionDataValidation = $request->InspectionAddValidation();
            }elseif(!in_array(strtoupper($requestData->ACTION),["DRAFT","SAVE","RENEW"])){
                $vvsInspectionDataValidation = $request->InspectionSaveValidation();
            }else{
                $vvsInspectionDataValidation = "";
            }
           
            if( $vvsInspectionDataValidation == "" ){
                //data saving in Inspection and associate table
                $InspectionDataSaved = $this->vvsInspectionService->save($requestData);
                if( $InspectionDataSaved ){
                    $saveMsg = "saved";
                    if(strtoupper($requestData->ACTION) == "DRAFT"){
                        $saveMsg = "drafted";
                    }
                    else if(strtoupper($requestData->ACTION) == "SAVE"){
                        $saveMsg = "saved";
                    }
                    else if(strtoupper($requestData->ACTION) == "RENEW"){
                        $saveMsg = "Renewed";
                    }
                    else if(strtoupper($requestData->ACTION) == "REQUEST_FOR_CLOSURE"){
                        $saveMsg = "requested for closure";
                    }
                    else if(strtoupper($requestData->ACTION) == "REQUEST_FOR_SUSPEND"){
                        $saveMsg = "requested for suspended";
                    }
                    else if(strtoupper($requestData->ACTION) == "MOVE_FORWARD"){
                        $saveMsg = "move forwarded";
                    }
                    else if(strtoupper($requestData->ACTION) == "SEND_BACK"){
                        $saveMsg = "sent back";
                    }
                    else if(strtoupper($requestData->ACTION) == "CLOSE"){
                        $saveMsg = "closed";
                    }
                    else if(strtoupper($requestData->ACTION) == "SUSPEND"){
                        $saveMsg = "suspended";
                    }
                    else if(strtoupper($requestData->ACTION) == "APPROVE"){
                        $saveMsg = "approved";
                    }
                    else if(strtoupper($requestData->ACTION) == "REJECT"){
                        $saveMsg = "rejected";
                    }

                    return $this->successMessage("Inspection (Ref. No. ".$InspectionDataSaved.") data has been ".$saveMsg.".");
                }else{
                    return $this->failureMessage(config('constants.SOMETHING_WRONG')." - data not saving.");
                }
            }else{
                return $this->failureMessage($vvsInspectionDataValidation);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

     /**
     * @param Request $request
     * @return InspectionResource
     */

     public function inspectionDetails(Request $request)
     {
         if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
             return $this->failureMessage("Request pattern is not valid.");
         }
         
         try {
             $vvsRequestData = $this->customDecrypt($request->X_KEY);
             $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
             $errorMessage = "";
 
             if (!$vvsUserData->toArray()) {
                 $errorMessage = "Token mismatch";
             } else {                 
                 $vvsValidationErrorData = $this->vvsInspectionViewRequest->editAPIInputValidation($vvsRequestData);
                 if (trim($vvsValidationErrorData) != "") {
                     $errorMessage = $vvsValidationErrorData;
                 } else { 
                     $vvsInspectionData = $this->vvsInspectionService->getInspectionDetails($vvsRequestData); 
                     $vvsaction = $vvsRequestData->ACTION ?? "";
                     if ($vvsInspectionData == "") {
                         $vvsInspectionOutput = [];
                     } else {
                         $editable = $vvsaction !== "view" && in_array($vvsInspectionData->STAGE_ID, [1,4,6]); 
                         $vvsButtonAccess = $this->InspectionButtonAceess($vvsUserData, $vvsInspectionData, $vvsaction);
                         $vvsInspectionRoleData = $vvsUserData->Inspectionroles;
                         $vvsUserRole = $vvsInspectionRoleData[0]->ROLE_ID;
                         $vvsInspectionTableOutput = InspectionResource::transformInspection($vvsInspectionData);
                         $vvsInspectionDecalarion = $this->getDeclaration($vvsInspectionData->ID, $vvsInspectionData->STAGE_ID, $vvsaction);
                         $vvsInspectionCheckList = $this->getCheckList($vvsInspectionData->ID, $vvsInspectionData->TYPE_ID, $vvsInspectionData->STAGE_ID, $vvsaction);
                         
                         $vvsInspectionRecalculatedOutput = [                             
                             "INSPECTION_FILES" => [
                                 "EDITABLE"      => ((in_array($vvsInspectionData->STAGE_ID,[1]) && ($vvsInspectionData->CREATED_BY == $request->CREATED_BY))?true:false),
                                 "VALUE"         => $this->vvsInspectionFileProcess->getInspectionFiles($vvsInspectionData->files, $vvsInspectionData->STAGE_ID, $vvsaction)
                             ],                            
                             "CHECKLIST" => $vvsInspectionCheckList["CHECKLIST"],                             
                             "IS_DRAFT_BTN"      => $vvsButtonAccess["IS_DRAFT_BTN"],
                             "IS_SUBMIT_BTN"     => $vvsButtonAccess["IS_SUBMIT_BTN"],
                             "IS_FORWARD_BTN"    => $vvsButtonAccess["IS_FORWARD_BTN"],
                             "IS_SEND_BACK_BTN"  => $vvsButtonAccess["IS_SEND_BACK_BTN"],
                             "IS_APPROVE_BTN"    => $vvsButtonAccess["IS_APPROVE_BTN"],
                             "IS_REJECT_BTN"     => $vvsButtonAccess["IS_REJECT_BTN"],
                             "IS_CLOSE_REQ_BTN"  => $vvsButtonAccess["IS_CLOSE_REQ_BTN"],
                             "IS_CLOSE_BTN"      => $vvsButtonAccess["IS_CLOSE_BTN"],
                             "IS_SUSPEND_REQ_BTN" => $vvsButtonAccess["IS_SUSPEND_REQ_BTN"],
                             "IS_SUSPEND_BTN"    => $vvsButtonAccess["IS_SUSPEND_BTN"],
                             "IS_RENEW_BTN"      => $vvsButtonAccess["IS_RENEW_BTN"],
                             "DECLARATION_1"     => $vvsInspectionDecalarion["DECLARATION_1"],
                             "DECLARATION_2"     => $vvsInspectionDecalarion["DECLARATION_2"]
                         ];
                         $vvsInspectionOutput = array_merge($vvsInspectionTableOutput, $vvsInspectionRecalculatedOutput);
                     }
                     return $this->successMessage($vvsInspectionOutput);
                 }
             }
 
             return $this->failureMessage($errorMessage);
         } catch (ValidationException $e) {
             return $this->failureMessage(config('constants.SOMETHING_WRONG'));
         }
     }
     
     private function getDeclaration($Inspection_id,$stageId, $vvsaction)
    {
        $afterSubmit = $stageId;
        if (in_array($stageId, [1])) {
          $afterSubmit = 1;
        }
        $vvsInspectionInitDeclOne = $this->vvsInspectionDeclService->getMapDeclarationOne($Inspection_id,$afterSubmit);
        $vvsInspectionInitDeclTwo = $this->vvsInspectionDeclService->getMapDeclarationTwo($Inspection_id,$afterSubmit);
        $vvsInspectionOutput["DECLARATION_1"]["EDITABLE"] = (($afterSubmit==1 && $vvsaction!="view")?true:false);
        $vvsInspectionOutput["DECLARATION_1"]["VALUE"] = InspectionMapDeclarationResource::collection($vvsInspectionInitDeclOne);
        $vvsInspectionOutput["DECLARATION_2"]["EDITABLE"] = (($afterSubmit==1 && $vvsaction!="view")?true:false);
        $vvsInspectionOutput["DECLARATION_2"]["VALUE"] = InspectionMapDeclarationResource::collection($vvsInspectionInitDeclTwo);
        return $vvsInspectionOutput;

    }

    private function getCheckList($Inspection_id,$type_id,$stageId, $vvsaction)
    {
        $afterSubmit = $stageId;
        if (in_array($stageId, [1])) {
          $afterSubmit = 1;
        }
        $vvsInspectionChkGen = $this->vvsInspectionCheckListService->getMapInspectionCheckList($Inspection_id,$type_id,$afterSubmit);
        $vvsGenOutPut1 = InspectionMapCheckListResource::collection($vvsInspectionChkGen);        
        $vvsInspectionOutput["CHECKLIST"]["EDITABLE"] = (($afterSubmit==1 && $vvsaction!="view")?true:false);
        $vvsInspectionOutput["CHECKLIST"]["VALUE"] = $vvsGenOutPut1;        
        return $vvsInspectionOutput;
    }

    private function InspectionButtonAceess($userDetails, $InspectionDetails, $vvsaction)
    {
        $vvsInspectionOutput = [
            "IS_DRAFT_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_SUBMIT_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_FORWARD_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_SEND_BACK_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_APPROVE_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_REJECT_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_CLOSE_REQ_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_CLOSE_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_SUSPEND_REQ_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_SUSPEND_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_RENEW_BTN" => ["EDITABLE"=>false,"VALUE"=>[]]
        ];

        $vvsInspectionUerRoleData = $userDetails->Inspectionroles;
        $vvsUserRole = $vvsInspectionUerRoleData[0]->ROLE_ID;

        $userId = $userDetails->ID;
        $stageId = $InspectionDetails->STAGE_ID;

        $this->handleInitiatorPart($vvsInspectionOutput, $userId, $InspectionDetails, $vvsaction);
        $this->handleReviewerPart($vvsInspectionOutput, $vvsUserRole, $stageId, $vvsaction);
        $this->handleApproverPart($vvsInspectionOutput, $vvsUserRole, $stageId, $vvsaction);

        return $vvsInspectionOutput;
    }

    private function handleInitiatorPart(&$vvsInspectionOutput, $userId, $InspectionDetails, $vvsaction)
    {
        $vvsCurTime = date('Y-m-d H:i:s');
        $vvsMinRenewDate = date("Y-m-d H:i:s", strtotime('+12 hours', strtotime($InspectionDetails->PERMIT_END_TIME)));
        if ($userId == $InspectionDetails->CREATED_BY && $vvsaction != "view") {
            if ((in_array($InspectionDetails->STAGE_ID,[1,4,6])) ||
                 ($InspectionDetails->STAGE_ID == 5 && strtoupper($vvsaction) == "RENEW")) {
                $vvsInspectionOutput["IS_DRAFT_BTN"]["EDITABLE"] = true;
                $vvsInspectionOutput["IS_SUBMIT_BTN"]["EDITABLE"] = true;
                $vvsInspectionOutput["IS_DRAFT_BTN"]["VALUE"] =  [];
                $vvsInspectionOutput["IS_SUBMIT_BTN"]["VALUE"] =  [];
            }
            if ($InspectionDetails->STAGE_ID == 5 && strtoupper($vvsaction) != "RENEW") {
                $vvsInspectionCloseDecl = $this->vvsInspectionDeclService->getInspectionCloseReqDeclList();
                $vvsInspectionOutput["IS_CLOSE_REQ_BTN"]["EDITABLE"] = true;
                $vvsInspectionOutput["IS_CLOSE_REQ_BTN"]["VALUE"] =  InspectionMstDeclarationResource::collection($vvsInspectionCloseDecl);

                $vvsInspectionSuspendDecl = $this->vvsInspectionDeclService->getInspectionSuspendReqDeclList();
                $vvsInspectionOutput["IS_SUSPEND_REQ_BTN"]["EDITABLE"] = true;
                $vvsInspectionOutput["IS_SUSPEND_REQ_BTN"]["VALUE"] = InspectionMstDeclarationResource::collection($vvsInspectionSuspendDecl);
                
                if($InspectionDetails->RENEWAL_COUNT <= 5){
                    //if(strtotime($vvsCurTime) >= strtotime($vvsMinRenewDate)){
                        $vvsInspectionRenewDecl = $this->vvsInspectionDeclService->getInspectionRenewDeclList();
                        $vvsInspectionOutput["IS_RENEW_BTN"]["EDITABLE"] = true;
                        $vvsInspectionOutput["IS_RENEW_BTN"]["VALUE"] =  InspectionMstDeclarationResource::collection($vvsInspectionRenewDecl);
                    //}
                }
                
            }
        }
    }

    private function handleReviewerPart(&$vvsInspectionOutput, $vvsUserRole, $stageId, $vvsaction)
    {
        if ($vvsUserRole == 2 && $vvsaction != "view") {
            if($stageId  == 2){
                $vvsInspectionOutput["IS_FORWARD_BTN"]["EDITABLE"] = true;
                $vvsInspectionDeclarations = $this->vvsInspectionDeclService->getInspectionMoveFrwdDeclList();
                $vvsInspectionOutput["IS_FORWARD_BTN"]["VALUE"] = InspectionMstDeclarationResource::collection($vvsInspectionDeclarations);

                $vvsInspectionOutput["IS_SEND_BACK_BTN"]["EDITABLE"] = true;
            }
            if ($stageId == 7) {
                $vvsInspectionOutput["IS_CLOSE_BTN"]["EDITABLE"] = true;
                $vvsInspectionCloseDecl = $this->vvsInspectionDeclService->getInspectionCloseDeclList();
                $vvsInspectionOutput["IS_CLOSE_BTN"]["VALUE"] = InspectionMstDeclarationResource::collection($vvsInspectionCloseDecl);
            }
            if ($stageId == 10) {
                $vvsInspectionOutput["IS_SUSPEND_BTN"]["EDITABLE"] = true;
                $vvsInspectionSuspendDecl = $this->vvsInspectionDeclService->getInspectionSuspendDeclList();
                $vvsInspectionOutput["IS_SUSPEND_BTN"]["VALUE"] = InspectionMstDeclarationResource::collection($vvsInspectionSuspendDecl);
            }
        }
    }

    private function handleApproverPart(&$vvsInspectionOutput, $vvsUserRole, $stageId, $vvsaction)
    {
        if ($vvsUserRole == 3 && $stageId == 3 && $vvsaction != "view") {
            $vvsInspectionOutput["IS_APPROVE_BTN"]["EDITABLE"] = true;
            $vvsInspectionApprDecl = $this->vvsInspectionDeclService->getInspectionApproveDeclList();
            $vvsInspectionOutput["IS_APPROVE_BTN"]["VALUE"] = InspectionMstDeclarationResource::collection($vvsInspectionApprDecl);

            $vvsInspectionOutput["IS_REJECT_BTN"]["EDITABLE"] = true;
            $vvsInspectionRejDecl = $this->vvsInspectionDeclService->getInspectionRejectDeclList();
            $vvsInspectionOutput["IS_REJECT_BTN"]["VALUE"] = InspectionMstDeclarationResource::collection($vvsInspectionRejDecl);
        }
    }

    public function inspectionActivityLog(Request $request)
    {
        if(!isset($request->X_KEY)){
            return $this->failureMessage("Request pattern is not valid.");
        }
        try {
            $vvsRequestData = $this->customDecrypt($request->X_KEY);
            $vvsInspectionData = $this->vvsInspectionService->getInspectionDetails($vvsRequestData);
            $inspId = $vvsInspectionData->ID;
            $vvsInspectionOutput = (new InspectionResource($vvsInspectionData))->transformInspectionReport($vvsInspectionData);
            $inspectionActivityLog = $this->vvsInspectionActivityLogService->getAllActivityLog($inspId);
            $vvsInspectionOutput['ACTIVITY_LOG'] = InspectionActionHistoryResource::collection($inspectionActivityLog);
            return $this->successMessage($vvsInspectionOutput);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return InspectionResource
     */
    public function inspectionDownloadableList(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $validationErrorData = $this->vvsInspectionListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                
                $inspectionDownloadableData = $this->vvsInspectionService->getInspectionDownloadableList($requestData);
                $searchCriteria = $this->vvsInspectionService->getSearchCriteriaList($requestData);
                $vvsInspectionTableOutput = [];
                foreach ($inspectionDownloadableData as $value){
                    $vvsInspectionTableOutput[] = (new InspectionResource($value))->transformInspectionDownloadableList($value);
                }
                
                $output = ["SEARCH_CRITERIA" => $searchCriteria, "INSPECTION_LIST" => $vvsInspectionTableOutput,];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    public function inspectionDetailsExport(Request $request)
    {
        if(!isset($request->X_KEY)){
            return $this->failureMessage("Request pattern is not valid.");
        }
        try {
            $vvsRequestData = $this->customDecrypt($request->X_KEY);
            $vvsInspectionData = $this->vvsInspectionService->getInspectionDetailsExport($vvsRequestData);
            $vvsInspectionOutput = (new InspectionResource($vvsInspectionData))
                                ->transformInspectionDownloadableList($vvsInspectionData);

            $afterSubmit = $vvsInspectionData->STAGE_ID;
            if (in_array($vvsInspectionData->STAGE_ID, [1])) {
            $afterSubmit = 1;
            }
            $vvsInspectionChkGen = $this->vvsInspectionCheckListService
                        ->getMapInspectionCheckList($vvsInspectionData->ID, $vvsInspectionData->TYPE_ID, $afterSubmit);
            $vvsInspectionCheckListOutput = [];
            foreach ($vvsInspectionChkGen as $checklistItem) {
                $vvsInspectionCheckListOutput[] =
                        InspectionMapCheckListResource::transformChecklistItem($checklistItem);
            }
            $vvsInspectionOutput["CHECKLIST"] = $vvsInspectionCheckListOutput;

            $vvsInspectionInitDeclOne = $this->vvsInspectionDeclService
                                    ->getMapDeclarationOne($vvsInspectionData->ID, $afterSubmit);
            $vvsInspectionInitDeclTwo = $this->vvsInspectionDeclService
                                    ->getMapDeclarationTwo($vvsInspectionData->ID, $afterSubmit);
            $vvsPtwOutput = [];
            foreach ($vvsInspectionInitDeclOne as $key => $value) {
                $vvsPtwOutput[$value->DECLARATION_SECTION][] = $value->DECLARATION_NAME;
            }foreach ($vvsInspectionInitDeclTwo as $key => $value) {
                $vvsPtwOutput[$value->DECLARATION_SECTION][] = $value->DECLARATION_NAME;
            }
            $vvsInspectionDeclOutput = array();
            $vvsInspectionDeclOutput["INSP_ADD_ONE"] = $vvsPtwOutput['INSP_ADD_ONE'] ?? [];
            $vvsInspectionDeclOutput["INSP_ADD_TWO"] = $vvsPtwOutput['INSP_ADD_TWO'] ?? [];
            $vvsInspectionOutput["DECLARATION"] = $vvsInspectionDeclOutput;
           
            return $this->successMessage([$vvsInspectionOutput]);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

}