<?php

namespace App\Repositories\INSPECTION;

use App\Http\Requests\INSPECTION\MasterListRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

use App\Http\Traits\EncDecService;
use App\Services\INSPECTION\InspectionMstTypeServices;
use App\Services\INSPECTION\InspectionMstLocationServices;
use App\Services\LocationServices;
use App\Services\INSPECTION\InspectionMstStageServices;
use App\Services\INSPECTION\InspectionCheckListServices;
use App\Services\INSPECTION\InspectionMstDeclarationServices;
use App\Services\INSPECTION\InspectionMstRecipentServices;
use App\Services\INSPECTION\InspectionServices;
use App\Services\UserServices;



use App\Http\Resources\INSPECTION\InspectionMstTypeResource;
use App\Http\Resources\INSPECTION\LocationResource;
use App\Http\Resources\INSPECTION\InspectionMstStageResource;
use App\Http\Resources\INSPECTION\InspectionCheckListOptionResource;
use App\Http\Resources\INSPECTION\InspectionCheckListResource;
use App\Http\Resources\INSPECTION\InspectionMstDeclarationResource;
use App\Http\Resources\INSPECTION\InspectionRecipentResource;
use App\Http\Resources\INSPECTION\InspectionReferenceResource;


class InspectionMasterListRepository implements InspectionMasterListInterface
{
    use EncDecService;
    public $vvsInspectionTypeService;
    public $vvsLocationService;

    public $vvsInspectionSopService;
    public $vvsInspectionStageService;
    public $vvsInspectionDesigService;
    public $vvsInspectionWorkerService;
    public $vvsInspectionCheckListService;
    public $vvsInspectionDeclService;
    public $vvsInspectionHiraService;
    public $vvsInspectionListRequest;
    public $vvsInspectionRecipentService;
    public $vvsInspectionService;
    public $vvsUserService;
   
    public function __construct()
    {
      $this->vvsInspectionTypeService = new InspectionMstTypeServices();
      $this->vvsLocationService = new InspectionMstLocationServices();
      $this->vvsInspectionStageService = new InspectionMstStageServices();      
      $this->vvsInspectionCheckListService = new InspectionCheckListServices();
      $this->vvsInspectionDeclService = new InspectionMstDeclarationServices();      
      $this->vvsInspectionRecipentService = new InspectionMstRecipentServices();
      $this->vvsInspectionService = new InspectionServices();
      $this->vvsUserService = new UserServices();

      $this->vvsInspectionListRequest = new MasterListRequest();

    }

   public function masterListInspection(Request $request){
        try {
            if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
                return $this->failureMessage("Request pattern is not valid.");
            }
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            if (!$vvsUserData->toArray()) {
                return $this->failureMessage("Token mismatch");
            }
            $vvsRawRequest = $this->customDecrypt($request->X_KEY);
            $vvsValidationErrorData = $this->vvsInspectionListRequest->masterAPIInputValidation($vvsRawRequest);
            if (trim($vvsValidationErrorData) != "") {
                return $this->failureMessage($vvsValidationErrorData);
            }

            //Inspection TYPE
            $vvsInspectiontypes = $this->vvsInspectionTypeService->getInspectionTypeList();
            $vvsMasterData["VVSInspectionTypes"] = InspectionMstTypeResource::collection($vvsInspectiontypes);             

            //Inspection STAGES
            $vvsInspectionStages = $this->vvsInspectionStageService->getInspectionStageList();
            $vvsMasterData["VVSInspectionStages"] = InspectionMstStageResource::collection($vvsInspectionStages);

            //LOCATIONS
            $vvsInspectionLocations = $this->vvsLocationService->getLocationList($vvsRawRequest);
            $vvsMasterData["VVSInspectionLocations"] = LocationResource::collection($vvsInspectionLocations);

            //Inspection DECLARATION
            $vvsInspectionDeclarationsOne = $this->vvsInspectionDeclService->getInspectionInitialDeclListOne();
            $vvsMasterData["InspectionDeclarationsOne"] = InspectionMstDeclarationResource::collection($vvsInspectionDeclarationsOne);

            $vvsInspectionDeclarationsTwo = $this->vvsInspectionDeclService->getInspectionInitialDeclListTwo();
            $vvsMasterData["InspectionDeclarationsTwo"] = InspectionMstDeclarationResource::collection($vvsInspectionDeclarationsTwo);

            $vvsInspectionRef = $this->vvsInspectionService->getAllInspection($vvsRawRequest);
            $vvsMasterData["InspectionReference"] = InspectionReferenceResource::collection($vvsInspectionRef);

            //PRECAUSION TAGGED BY LIST
            $vvsInspectionTagBy = $this->vvsInspectionRecipentService->getInspectionRecipentList($vvsRawRequest);
            $vvsMasterData["InspectionRecipentList"] = InspectionRecipentResource::collection($vvsInspectionTagBy);            
            
            return $this->successMessage( $vvsMasterData);
            
        }catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    public function masterChekListInspection(Request $request){
        try {
            if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
                return $this->failureMessage("Request pattern is not valid.");
            }
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            if (!$vvsUserData->toArray()) {
                return $this->failureMessage("Token mismatch");
            }
            $vvsRawRequest = $this->customDecrypt($request->X_KEY);
            $vvsValidationErrorData = $this->vvsInspectionListRequest->checkListAPIInputValidation($vvsRawRequest);
            if (trim($vvsValidationErrorData) != "") {
                return $this->failureMessage($vvsValidationErrorData);
            }
            //Inspection CHECKLIST
            $vvsInspectionCheckList = $this->vvsInspectionCheckListService->getInspectionCheckList($vvsRawRequest);            
            $vvsMasterData["VVSInspectionCheckList"] = InspectionCheckListResource::collection($vvsInspectionCheckList);

            

            return $this->successMessage( $vvsMasterData);
            
        }catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

}
