<?php

namespace App\Repositories\INSPECTION;

use App\Http\Controllers\Controller;
use App\Services\INSPECTION\InspectionServices;


class InspectionFileProcess extends Controller
{
    public $vvsInspectionService;

    /**
     * InspectionFileProcess constructor.
     */

     public function __construct()
     {
         $this->vvsInspectionService = new InspectionServices();
         
     }

    protected function getFileTypeFromUrl($url)
    {
        $vvsreturnData = "unknown";
        $vvsurlArray = explode(".", $url);
        $vvsurlLastElement = end($vvsurlArray);
        if (in_array(strtoupper($vvsurlLastElement), ['PNG', 'JPEG', 'JPG'])) {
            $vvsreturnData = 'image';
        } elseif (in_array(strtoupper($vvsurlLastElement), ['PDF'])) {
            $vvsreturnData = 'application/pdf';
        } elseif (in_array(strtoupper($vvsurlLastElement), ['MP4'])) {
            $vvsreturnData = 'video';
        }
        return $vvsreturnData;
    }

    public function getInspectionFiles($vvsInspectionFiles, $vvsstageId, $vvsaction = null)
    {
        $vvsInspectionFileArray = [];

        $vvsUploadPath = config('constants.INSP_FILE_UPLOAD_PATH');

        if (!empty($vvsInspectionFiles)) {
            foreach ($vvsInspectionFiles as $key1 => $value1) {
                $fileArray = $value1->toArray();
                foreach ($fileArray as $key2 => $value2) {
                    $vvsInspectionFileArray[$key1][$key2] = $value2;

                    if ($key2 == 'FILE_NAME') {
                        $vvsImagePath = asset('public/' . $vvsUploadPath . $value2);
                        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);

                        $vvsInspectionFileArray[$key1][$key2] = str_replace('./' . $vvsUploadPath, '', $value2);
                        $vvsInspectionFileArray[$key1]['INSPECTION_FILE'] = $vvsImagePath;
                        $vvsInspectionFileArray[$key1]['MEDIA_TYPE_NAME'] = $this->getFileTypeFromUrl($vvsImagePath);
                        $vvsInspectionFileArray[$key1]['IS_DELETE'] = $vvsstageId == 1 && $vvsaction !== 'view';
                    }
                }
            }
        }

        return $vvsInspectionFileArray;
    }

   
 
}
