<?php

namespace App\Repositories\HIRA;

use App\Http\Requests\HIRA\HiraListRequest;
use App\Http\Requests\HIRA\HiraViewRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;
use App\Http\Requests\HIRA\AddRequest;

use App\Http\Traits\EncDecService;
use App\Services\HIRA\HiraServices;
use App\Services\HIRA\HiraActivityServices;
use App\Services\HIRA\HiraMstDeclarationServices;
use App\Services\HIRA\HiraActionHistoryServices;
use App\Http\Resources\HIRA\HiraActionHistoryResource;
use App\Services\UserServices;

use App\Models\MstLocation;

use App\Http\Resources\HIRA\HiraResource;
use App\Http\Resources\HIRA\HiraActivityResource;
use App\Http\Resources\HIRA\HiraMstDeclarationResource;
use App\Http\Resources\HIRA\HiraMapDeclarationResource;

class HiraRepository implements HiraInterface
{
    use EncDecService;
    public $vvsHiraListRequest;
    public $vvsHiraService;
    public $vvsHiraAddRequest;
    public $vvsHiraDeclService;
    public $vvsHiraViewRequest;
    public $vvsUserService;
    public $vvsHiraActivityService;    
    public $vvsHiraActivityLogService;

    public function __construct()
    {
        $this->vvsUserService = new UserServices();
        $this->vvsHiraListRequest = new HiraListRequest();
        $this->vvsHiraViewRequest = new HiraViewRequest();
        $this->vvsHiraService = new HiraServices();
        $this->vvsHiraActivityService = new HiraActivityServices();
        $this->vvsHiraDeclService = new HiraMstDeclarationServices();
        $this->vvsHiraActivityLogService = new HiraActionHistoryServices();
        $this->vvsHiraAddRequest = new AddRequest();
    }

    public function listHira(Request $request){
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsHiraUerRoleData = $vvsUserData->hiraroles;
            $vvsUserRole = "";
            if(isset($vvsHiraUerRoleData) && !empty($vvsHiraUerRoleData)){
                $vvsUserRole = $vvsHiraUerRoleData[0]->ROLE_ID;
            }            
            $validationErrorData = $this->vvsHiraListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsHiraData = $this->vvsHiraService->getHiraList($requestData);
                $hiraTotalCount = $this->vvsHiraService->getHiraListTotalCount($requestData);
                $hiraList = HiraResource::collection($vvsHiraData);
                $calculatedTab = $this->vvsHiraService->calculatedTab($requestData);
                $output = ["TAB" => $calculatedTab, "HIRA_LIST" => $hiraList,"TOTAL_NO" => $hiraTotalCount,
                            "IS_ADD_BTN"=>(($vvsUserRole == 4)?true:false)];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return HiraResource
     */

    public function hiraDetails(Request $request)
    {
        if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
            return $this->failureMessage("Request pattern is not valid.");
        }
        
        try {
            $vvsRequestData = $this->customDecrypt($request->X_KEY);
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $errorMessage = "";

            if (!$vvsUserData->toArray()) {
                $errorMessage = "Token mismatch";
            } else {
                
                $vvsValidationErrorData = $this->vvsHiraViewRequest->editAPIInputValidation($vvsRequestData);
                if (trim($vvsValidationErrorData) != "") {
                    $errorMessage = $vvsValidationErrorData;
                } else {

                    $vvsActionOwnerId = 0;
                    $vvsHiraData = $this->vvsHiraService->getHiraDetails($vvsRequestData);
                    $vvsHiraActivityData = $this->vvsHiraActivityService->getHiraActivityList($vvsRequestData);
                    //$vvsHiraActivityData = $vvsHiraData->activities;
                    $vvsHiraActivityFirstData = $this->vvsHiraActivityService->getHiraActivityFirstList($vvsRequestData);                    
                    if(!empty($vvsHiraActivityFirstData)){
                        $vvsActionOwnerId = $vvsHiraActivityFirstData->ACTION_OWNER_ID;
                    }

                    $vvsaction = $vvsRequestData->ACTION ?? "";
                    if ($vvsHiraData == "") {
                        $vvsHiraOutput = [];
                    } else {
                        $vvsHiraUerRoleData = $vvsUserData->hiraroles;
                        $vvsUserRole = $vvsHiraUerRoleData[0]->ROLE_ID;
                        $editable = false;
                        $editable1 = false;
                        if($vvsaction !== "view" && in_array($vvsHiraData->STAGE_ID, [3]) && $vvsUserRole == 6){
                            $editable = true;
                            $editable1 = true; 
                        }else if($vvsaction !== "view" && in_array($vvsHiraData->STAGE_ID, [2,6]) && $vvsUserRole == 5){
                            $editable = true;
                            $editable1 = true;  
                        }else if($vvsaction !== "view" && in_array($vvsHiraData->STAGE_ID, [1,4]) && $request->CREATED_BY == $vvsHiraData->CREATED_BY){
                            $editable = true;
                            $editable1 = true;   
                        }else if($vvsaction !== "view" && in_array($vvsHiraData->STAGE_ID, [5]) && $request->CREATED_BY == $vvsHiraData->CREATED_BY){
                            $editable = true;                            
                        }
                                                
                        $vvsHiraDecalarion = $this->getDeclaration($vvsHiraData->ID,
                                                                 $vvsHiraData->STAGE_ID, $vvsaction);
                        $vvsButtonAccess = $this->hiraButtonAceess($vvsUserData, $vvsHiraData, $vvsaction,  $vvsActionOwnerId);               
                        $vvsHiraOutput = [
                            "ID" => [
                                "EDITABLE"      => false,
                                "VALUE"         => $vvsHiraData->ID
                            ],
                            "HIRA_DTLS" => [
                                "EDITABLE"      => $editable1,
                                "VALUE"         => HiraResource::transformHira($vvsHiraData)
                            ],
                            "ACTIVITY_DTLS" => [
                                "EDITABLE"      => $editable,
                                "VALUE"         => HiraActivityResource::collection($vvsHiraActivityData)
                            ],
                            "DECLARATION"       => $vvsHiraDecalarion["DECLARATION"],
                            "IS_DRAFT_BTN"      => $vvsButtonAccess["IS_DRAFT_BTN"],
                            "IS_FORWARD_BTN"    => $vvsButtonAccess["IS_FORWARD_BTN"],
                            "IS_SEND_BACK_BTN"  => $vvsButtonAccess["IS_SEND_BACK_BTN"],
                            "IS_SUBMIT_BTN"     => $vvsButtonAccess["IS_SUBMIT_BTN"],
                            "IS_APPROVE_BTN"    => $vvsButtonAccess["IS_APPROVE_BTN"],
                            "IS_REJECT_BTN"     => $vvsButtonAccess["IS_REJECT_BTN"],
                            "IS_REVISE_BTN"     => $vvsButtonAccess["IS_REVISE_BTN"],
                            "IS_RENEW_BTN"      => $vvsButtonAccess["IS_RENEW_BTN"],
                            "IS_ACCEPT_CONTROL_MEASURE"      => $vvsButtonAccess["IS_ACCEPT_CONTROL_MEASURE"],
                        ];
                    }
                    return $this->successMessage($vvsHiraOutput);
                }
            }

            return $this->failureMessage($errorMessage);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    private function hiraButtonAceess($userDetails, $hiraDetails, $vvsaction, $actionOwnerId)
    {
        $vvsHiraOutput = [
            "IS_DRAFT_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_SUBMIT_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_FORWARD_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_SEND_BACK_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_APPROVE_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_ACCEPT_CONTROL_MEASURE" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_REJECT_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_RENEW_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_REVISE_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_ACCEPT_CONTROL_MEASURE" => ["EDITABLE"=>false,"VALUE"=>[]]
        ];

        $vvsHiraUerRoleData = $userDetails->hiraroles;
        $vvsUserRole = $vvsHiraUerRoleData[0]->ROLE_ID;

        
        $userId = $userDetails->ID;
        $stageId = $hiraDetails->STAGE_ID;

        $vvsHiraActionControl = $this->vvsHiraActivityService->getHiraActionControl($hiraDetails,$userId);

        if($stageId==5){
            $vvsHiraACMDecl = $this->vvsHiraDeclService->getHiraACMlList();
            $vvsHiraOutput["IS_ACCEPT_CONTROL_MEASURE"]["EDITABLE"] = true;
            $vvsHiraOutput["IS_ACCEPT_CONTROL_MEASURE"]["VALUE"] = HiraMstDeclarationResource::collection($vvsHiraACMDecl);
        }

        $this->handleInitiatorPart($vvsHiraOutput, $userId, $hiraDetails, $vvsaction);
        $this->handleReviewerPart($vvsHiraOutput, $vvsUserRole, $stageId, $vvsaction);
        $this->handleApproverPart($vvsHiraOutput, $vvsUserRole, $stageId, $vvsaction);

        return $vvsHiraOutput;
    }

    private function handleInitiatorPart(&$vvsHiraOutput, $userId, $hiraDetails, $vvsaction)
    {
        $vvsCurTime = date('Y-m-d H:i:s');
        // $vvsMinRenewDate = date("Y-m-d H:i:s", strtotime('+12 hours', strtotime($hiraDetails->PERMIT_END_TIME)));
        if ($userId == $hiraDetails->CREATED_BY && $vvsaction != "view") {
            if ((in_array($hiraDetails->STAGE_ID,[1,4])) ||
                 ($hiraDetails->STAGE_ID == 5 && (strtoupper($vvsaction) == "RENEW" || strtoupper($vvsaction) == "REVISE"))) {
                $vvsHiraOutput["IS_DRAFT_BTN"]["EDITABLE"] = true;
                $vvsHiraOutput["IS_SUBMIT_BTN"]["EDITABLE"] = true;
                $vvsHiraOutput["IS_DRAFT_BTN"]["VALUE"] =  [];
                $vvsHiraOutput["IS_SUBMIT_BTN"]["VALUE"] =  [];
            }
            $vvsCurTime = date('Y-m-d');
            $vvsMinRenewDate = date("Y-m-d", strtotime('+1 day', strtotime($hiraDetails->HIRA_END_DATE))); 
            if ($hiraDetails->STAGE_ID == 5 && (strtotime($vvsCurTime) < strtotime($vvsMinRenewDate)) 
                && strtoupper($vvsaction) != "REVISE" && strtoupper($vvsaction) != "RENEW") {              
                $vvsHiraRenewDecl = $this->vvsHiraDeclService->getHiraRenewDeclList();
                $vvsHiraOutput["IS_REVISE_BTN"]["EDITABLE"] = true;
                $vvsHiraOutput["IS_REVISE_BTN"]["VALUE"] =  HiraMstDeclarationResource::collection($vvsHiraRenewDecl);
                //$vvsHiraOutput["IS_REVISE_BTN"]["VALUE"] =  []; 
            }
                           
            if ($hiraDetails->STAGE_ID == 5 && (strtotime($vvsCurTime) >= strtotime($vvsMinRenewDate)) 
                && strtoupper($vvsaction) != "REVISE" && strtoupper($vvsaction) != "RENEW") {             
                $vvsHiraRenewDecl = $this->vvsHiraDeclService->getHiraRenewDeclList();
                $vvsHiraOutput["IS_RENEW_BTN"]["EDITABLE"] = true;
                $vvsHiraOutput["IS_RENEW_BTN"]["VALUE"] =  HiraMstDeclarationResource::collection($vvsHiraRenewDecl);
                //$vvsHiraOutput["IS_RENEW_BTN"]["VALUE"] =  []; 
            }
        }
    }

    private function handleReviewerPart(&$vvsHiraOutput, $vvsUserRole, $stageId, $vvsaction)
    {
        if ($vvsUserRole == 5 && $vvsaction != "view") {            
            if ($stageId == 6) {                
                $vvsHiraOutput["IS_SUBMIT_BTN"]["EDITABLE"] = true;                
                $vvsHiraOutput["IS_SUBMIT_BTN"]["VALUE"] =  [];
            }
            if($stageId  == 2){
                $vvsHiraOutput["IS_FORWARD_BTN"]["EDITABLE"] = true;
                $vvsHiraDeclarations = $this->vvsHiraDeclService->getHiraMoveFrwdDeclList();
                $vvsHiraOutput["IS_FORWARD_BTN"]["VALUE"] = HiraMstDeclarationResource::collection($vvsHiraDeclarations);

                $vvsHiraOutput["IS_SEND_BACK_BTN"]["EDITABLE"] = true;
            }            
        }
    }

    private function handleApproverPart(&$vvsHiraOutput, $vvsUserRole, $stageId, $vvsaction)
    {
        if ($vvsUserRole == 6 && $stageId == 3 && $vvsaction != "view") {
            $vvsHiraOutput["IS_APPROVE_BTN"]["EDITABLE"] = true;
            $vvsHiraApprDecl = $this->vvsHiraDeclService->getHiraApproveDeclList();
            $vvsHiraOutput["IS_APPROVE_BTN"]["VALUE"] = HiraMstDeclarationResource::collection($vvsHiraApprDecl);

            $vvsHiraOutput["IS_REJECT_BTN"]["EDITABLE"] = true;
            $vvsHiraRejDecl = $this->vvsHiraDeclService->getHiraRejectDeclList();
            $vvsHiraOutput["IS_REJECT_BTN"]["VALUE"] = HiraMstDeclarationResource::collection($vvsHiraRejDecl);
            
        }
    }

    private function getDeclaration($hira_id, $stageId, $vvsaction)
    {
        $afterSubmit = $stageId;
        if (in_array($stageId, [1,4,6])) {
          $afterSubmit = 1;
        }
        $vvsHiraInitDecl = $this->vvsHiraDeclService->getMapDeclaration($hira_id,$afterSubmit);        
        $vvsHiraOutput["DECLARATION"]["EDITABLE"] = (($afterSubmit==1 && $vvsaction!="view")?true:false);
        $vvsHiraOutput["DECLARATION"]["VALUE"] = HiraMapDeclarationResource::collection($vvsHiraInitDecl);
        return $vvsHiraOutput;

    }

    public function hiraAdd(Request $request){
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            //checking role access for action
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);

            $roleIds = array_map(function($item) {
                return $item['ROLE_ID'];
            }, $vvsUserData ->hiraroles->toArray());
            if(in_array(4,$roleIds) && !in_array(strtoupper($requestData->ACTION),["DRAFT","SAVE","RENEW","REVISE"])){
            return $this->failureMessage("Sorry! You are not permitted to create a Hira.");
            } 
            
            
            if($requestData->ACTION == "DELETE"){
                $requestData->HIRA_ID = $requestData->ID;
                $vvsHiraData = $this->vvsHiraService->getHiraDetails($requestData);
                if($vvsHiraData->activities->count() > 0){
                    return $this->failureMessage("Sorry! You are not permitted to take the selected action due to exist Activity List");
                }
            }

            if($requestData->ACTION != "DELETE"){
                $vvsHiraDataValidation = $request->hiraAddValidation();
            }elseif(in_array(strtoupper($requestData->ACTION),["RENEW","REVISE"])){
                $vvsHiraDataValidation = $request->hiraInfoAddValidation();
            }else{
                $vvsHiraDataValidation = "";
            }            
            
            if( $vvsHiraDataValidation == "" ){
                //data saving in Hira and associate table
                $hiraDataSaved = $this->vvsHiraService->save($requestData);
                if( $hiraDataSaved ){
                    if($requestData->ACTION == "DELETE"){
                        $saveMsg = "deleted";  
                    }elseif($requestData->ACTION == "RENEW"){
                        $saveMsg = "created";  
                    }elseif($requestData->ACTION == "REVISE"){
                        $saveMsg = "revised";  
                    }else{
                        $saveMsg = "saved";  
                    }                                      
                    $vvsHiraOutput = ["HIRA_ID"=>$hiraDataSaved->ID,"dataMessage"=>"HIRA (Ref. No. ".$hiraDataSaved->HIRA_REFERENCE_NO.") data has been ".$saveMsg."."];
                        return $this->successMessage($vvsHiraOutput);
                }else{
                    return $this->failureMessage(config('constants.SOMETHING_WRONG')." - data not saving.");
                }
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    public function hiraAddInfo(Request $request){
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData->CREATED_BY = $request->CREATED_BY;
            
            //checking role access for action
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);

            $roleIds = array_map(function($item) {
                return $item['ROLE_ID'];
            }, $vvsUserData ->hiraroles->toArray());
            if(in_array(4,$roleIds) && !in_array(strtoupper($requestData->ACTION),["DRAFT","SAVE","RENEW","REVISE"])){
            return $this->failureMessage("Sorry! You are not permitted to create a Hira.");
            }
            if(in_array(5,$roleIds) && !in_array(strtoupper($requestData->ACTION),["DRAFT","SAVE","MOVE_FORWARD","SEND_BACK"])){
            return $this->failureMessage("Sorry! You are not permitted to take the selected action.");
            }
            if(in_array(6,$roleIds) && !in_array(strtoupper($requestData->ACTION),["APPROVE","REJECT"])){
            return $this->failureMessage("Sorry! You are not permitted to take the selected action.");
            }            

            if(in_array(strtoupper($requestData->ACTION),["MOVE_FORWARD","SEND_BACK","APPROVE","REJECT"])){
                $requestData->HIRA_ID = $requestData->ID;
                $vvsHiraData = $this->vvsHiraService->getHiraDetails($requestData);
                if($vvsHiraData->activities->count() <= 0){
                    return $this->failureMessage("Sorry! You are not permitted to take the selected action.");
                }
            }
            if(in_array(strtoupper($requestData->ACTION),["SAVE"])){
                $requestData->HIRA_ID = $requestData->ID;
                $vvsHiraData = $this->vvsHiraService->getHiraDetails($requestData);
                if(($vvsHiraData->activities->count() <= 0) &&
                 ((!isset($requestData->ACTIVITY_DTLS)) || (count($requestData->ACTIVITY_DTLS) <=0 ))){
                    return $this->failureMessage("Sorry! You are not permitted to take the selected action.");
                }
            }
            
            if(in_array(strtoupper($requestData->ACTION),["DRAFT","SAVE"])){
                $vvsHiraDataValidation = $request->hiraInfoAddValidation();
            }elseif(!in_array(strtoupper($requestData->ACTION),["DRAFT","SAVE","RENEW","REVISE"])){
                $vvsHiraDataValidation = $request->hiraSaveValidation();
            }else{
                $vvsHiraDataValidation = "";
            }             
            if( $vvsHiraDataValidation == "" ){
                //data saving in Hira and associate table               
                $hiraDataSaved = $this->vvsHiraService->saveInfo($requestData);
                
                if( $hiraDataSaved ){
                    $saveMsg = "saved";
                    if(strtoupper($requestData->ACTION) == "DRAFT"){
                        $saveMsg = "drafted";
                    }
                    else if(strtoupper($requestData->ACTION) == "SAVE"){
                        $saveMsg = "saved";
                    }
                    else if(strtoupper($requestData->ACTION) == "RENEW"){
                        $saveMsg = "Renewed";
                    }                    
                    else if(strtoupper($requestData->ACTION) == "MOVE_FORWARD"){
                        $saveMsg = "move forwarded";
                    }
                    else if(strtoupper($requestData->ACTION) == "SEND_BACK"){
                        $saveMsg = "sent back";
                    }                   
                    else if(strtoupper($requestData->ACTION) == "APPROVE"){
                        $saveMsg = "approved";
                    }
                    else if(strtoupper($requestData->ACTION) == "REJECT"){
                        $saveMsg = "rejected";
                    }
                    else if(strtoupper($requestData->ACTION) == "REVISE"){
                        $saveMsg = "Revised";
                    }                    
                    if(strtoupper($requestData->ACTION) == "DRAFT" && $requestData->ID == 0){
                        $vvsHiraOutput = ["HIRA_ID"=>$hiraDataSaved->ID,"dataMessage"=>"HIRA (Ref. No. ".$hiraDataSaved->HIRA_REFERENCE_NO.") data has been ".$saveMsg."."];
                        return $this->successMessage($vvsHiraOutput);
                    }
                    if(strtoupper($requestData->ACTION) == "DRAFT" && $requestData->ID == 0){
                        $vvsHiraOutput = ["HIRA_ID"=>$hiraDataSaved->ID,"dataMessage"=>"HIRA (Ref. No. ".$hiraDataSaved->HIRA_REFERENCE_NO.") data has been ".$saveMsg."."];
                        return $this->successMessage($vvsHiraOutput);
                    }
                    return $this->successMessage("HIRA (Ref. No. ".$hiraDataSaved->HIRA_REFERENCE_NO.") data has been ".$saveMsg.".");
                }else{
                    return $this->failureMessage(config('constants.SOMETHING_WRONG')." - data not saving.");
                }
            }else{
                return $this->failureMessage($vvsHiraDataValidation);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    public function hiraActivityLog(Request $request)
    {
        if(!isset($request->X_KEY)){
            return $this->failureMessage("Request pattern is not valid.");
        }
        try {
            $vvsRequestData = $this->customDecrypt($request->X_KEY);
            $vvsHiraData = $this->vvsHiraService->getHiraDetails($vvsRequestData);
            $hiraId = $vvsHiraData->ID;
            if($vvsHiraData->TOP_PARENT_HIRA_ID > 0){
                $hiraId = $vvsHiraData->TOP_PARENT_HIRA_ID;
            }
            $vvsHiraOutput = (new HiraResource($vvsHiraData))->transformHiraReport($vvsHiraData);
            $hiraActivityLog = $this->vvsHiraActivityLogService->getAllActivityLog($hiraId);
            $vvsHiraOutput['ACTIVITY_LOG'] = HiraActionHistoryResource::collection($hiraActivityLog);
            return $this->successMessage($vvsHiraOutput);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    public function hiraDetailsExport(Request $request)
    {
        if(!isset($request->X_KEY)){
            return $this->failureMessage("Request pattern is not valid.");
        }        
        try {
            $vvsRequestData = $this->customDecrypt($request->X_KEY);
            $vvsHiraData = $this->vvsHiraService->getHiraDetails($vvsRequestData);
            $vvsHiraOutput = (new HiraResource($vvsHiraData))->transformHiraXlReport($vvsHiraData);
            $vvsHiraActivities = $vvsHiraData->hiraactives;
            $vvsHiraOutput['ACTIVITIES'] = HiraActivityResource::collection($vvsHiraActivities);
            $hiraId = $vvsHiraData->ID;
            if($vvsHiraData->TOP_PARENT_HIRA_ID > 0){
                $hiraId = $vvsHiraData->TOP_PARENT_HIRA_ID;
            }
            $hiraActivityLog = $this->vvsHiraActivityLogService->getAllActivityLog($hiraId);
            $vvsHiraOutput['ACTIVITY_LOG'] = HiraActionHistoryResource::collection($hiraActivityLog); 
            $vvsHiraOutput['REVISION_COUNT'] = $vvsHiraData->renewedhira->count();
            $vvsHiraOutput['REVISIONS'][] = (new HiraResource($vvsHiraData))->transformHiraRevisionReport($vvsHiraData);
            if($vvsHiraData->renewedhira->count() > 0){
                foreach ($vvsHiraData->renewedhira as $key => $value) {
                    $vvsHiraOutput['REVISIONS'][] = (new HiraResource($value))->transformHiraRevisionReport($value);
                }
            }          
            return $this->successMessage($vvsHiraOutput);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    public function hiraAddAcm(Request $request){
        try {
            $requestData = $this->customDecrypt($request->X_KEY);                     
            $requestData->CREATED_BY = $request->CREATED_BY;            
            //checking role access for action
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);

            $roleIds = array_map(function($item) {
                return $item['ROLE_ID'];
            }, $vvsUserData ->hiraroles->toArray());
            if((!isset($roleIds) || empty($roleIds)) && in_array(strtoupper($requestData->ACTION),["ACM"])){
            return $this->failureMessage("Sorry! You are not permitted to create a Hira.");
            }

            $vvsHiraDataValidation = $request->hiraAddACMValidation();
            
            if( $vvsHiraDataValidation == "" ){
                $hiraDataSaved = $this->vvsHiraService->saveHiraAcm($requestData);
                if( $hiraDataSaved ){
                    return $this->successMessage("HIRA (Ref. No. ".$hiraDataSaved->HIRA_REFERENCE_NO.") ACM data has been updated successfully");
                }
            }
            
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        } 
    }

     /**
     * @param Request $request
     * @return HiraResource
     */
    public function hiraDownloadableList(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $validationErrorData = $this->vvsHiraListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                
                $hiraDownloadableData = $this->vvsHiraService->getHiraDownloadableList($requestData);
                $searchCriteria = $this->vvsHiraService->getSearchCriteriaList($requestData);
                $vvsHiraTableOutput = [];
                // prd(1);
                foreach ($hiraDownloadableData as $value){
                    $vvsHiraOutput = (new HiraResource($value))->transformHiraListReport($value);
                    $vvsHiraActivities = $value->hiraactives;
                    if(isset($vvsHiraActivities) && !empty($vvsHiraActivities)){
                        $activities = [];
                        foreach ($vvsHiraActivities as $activity) {
                            $activities[] = HiraActivityResource::transformHiraActivityListReport($activity);
                        }
                        $vvsHiraOutput['ACTIVITIES'] = $activities;
                    }
                    // $hiraId = $value->ID;
                    // if($value->TOP_PARENT_HIRA_ID > 0){
                    //     $hiraId = $value->TOP_PARENT_HIRA_ID;
                    // }
                    // $hiraActivityLog = $this->vvsHiraActivityLogService->getAllActivityLog($hiraId);
                    // $vvsHiraOutput['ACTIVITY_LOG'] = HiraActionHistoryResource::collection($hiraActivityLog); 
                    // $vvsHiraOutput['REVISION_COUNT'] = $value->renewedhira->count();
                    // $vvsHiraOutput['REVISIONS'][] = HiraResource::transformHiraRevisionReport($value);
                    // if($value->renewedhira->count() > 0){
                    //     foreach ($value->renewedhira as $key => $value2) {
                    //         $vvsHiraOutput['REVISIONS'][] = HiraResource::transformHiraRevisionReport($value2);
                    //     }
                    // }
                    $vvsHiraTableOutput[] = $vvsHiraOutput;
                }
                
                $output = ["SEARCH_CRITERIA" => $searchCriteria, "HIRA_LIST" => $vvsHiraTableOutput,];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    public function hiraWiseLog(Request $request){
        if(!isset($request->X_KEY)){
            return $this->failureMessage("Request pattern is not valid.");
        }
        try {
            $vvsRequestData = $this->customDecrypt($request->X_KEY);
            $hiraActivityId = 0 ;
            if(isset($vvsRequestData->HIRA_ACTIVITY_ID)){
                $hiraActivityId = $vvsRequestData->HIRA_ACTIVITY_ID;
            }
            $vvsHiraLogData = $this->vvsHiraService->getHiraLogDetails($vvsRequestData->HIRA_ID,$hiraActivityId);
           
            return $this->successMessage($vvsHiraLogData);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    public function hiraAddDeclarationM(Request $request){
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData->CREATED_BY = $request->CREATED_BY;
            //checking role access for action
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);

            $roleIds = array_map(function($item) {
                return $item['ROLE_ID'];
            }, $vvsUserData ->hiraroles->toArray());
            if((!isset($roleIds) || empty($roleIds)) && in_array(strtoupper($requestData->ACTION),["ACM"])){
            return $this->failureMessage("Sorry! You are not permitted to create a Hira.");
            }

            $hiraDataSaved = $this->vvsHiraService->saveHiraDeclarationM($requestData);
            if( $hiraDataSaved ){
                return $this->successMessage("Declaration data has been saved successfully");
            }
            
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        } 
    }

}