<?php

namespace App\Repositories\HIRA;

use App\Http\Requests\HIRA\HiraMasterListRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

use App\Http\Traits\EncDecService;
use App\Services\PTW\PtwMstTypeServices;
use App\Services\HIRA\HiraMstJobServices;
use App\Services\HIRA\HiraMstLikelihoodServices;
use App\Services\HIRA\HiraMstSeverityServices;
use App\Services\HIRA\HiraMstStageServices;
use App\Services\HIRA\HiraMstDeclarationServices;
use App\Services\HIRA\HiraMstActivityServices;
use App\Services\HIRA\HiraMstRiskRelatedServices;
use App\Services\HIRA\HiraMstLocationServices;
use App\Services\UserServices;
use App\Services\HIRA\HiraActionOwnerServices;

use App\Models\MstLocation;

use App\Http\Resources\PTW\PtwMstTypeResource;
use App\Http\Resources\HIRA\HiraMstJobResource;
use App\Http\Resources\HIRA\HiraMstLikelihoodResource;
use App\Http\Resources\HIRA\HiraMstSeverityResource;
use App\Http\Resources\HIRA\HiraMstStageResource;
use App\Http\Resources\HIRA\HiraMstDeclarationResource;
use App\Http\Resources\HIRA\HiraMstActivityResource;
use App\Http\Resources\HIRA\HiraMstRiskRelatedResource;
use App\Http\Resources\HIRA\HiraLocationResource;
use App\Http\Resources\UserResource;
use App\Http\Resources\HIRA\HiraActionOwnerResource;

class HiraMasterListRepository implements HiraMasterListInterface
{
    use EncDecService;
    public $vvsPtwTypeService;
    public $vvsHiraJobService;
    public $vvsHiraLikelihoodService;
    public $vvsHiraSeverityService;
    public $vvsHiraStageService;
    public $vvsHiraDeclService;
    public $vvsHiraActivityService;
    public $vvsHiraRiskRelatedService;
    public $vvsLocationService;
    public $vvsUserService;
    public $vvsHiraActionOwnerService;

    public function __construct()
    {
        $this->vvsPtwTypeService = new PtwMstTypeServices();
        $this->vvsHiraJobService = new HiraMstJobServices();
        $this->vvsHiraLikelihoodService = new HiraMstLikelihoodServices();
        $this->vvsHiraSeverityService = new HiraMstSeverityServices();
        $this->vvsHiraStageService = new HiraMstStageServices();
        $this->vvsHiraDeclService = new HiraMstDeclarationServices();
        $this->vvsHiraActivityService = new HiraMstActivityServices();
        $this->vvsHiraRiskRelatedService = new HiraMstRiskRelatedServices();
        $this->vvsLocationService = new HiraMstLocationServices();
        $this->vvsUserService = new UserServices();
        $this->vvsHiraActionOwnerService = new HiraActionOwnerServices();

        $this->vvsHiraMasterListRequest = new HiraMasterListRequest();
    }

    public function masterListHira(Request $request){
        try {
            if (!isset($request->X_KEY) || empty($request->CREATED_BY)){
                return $this->failureMessage("Request pattern is not valid.");
            }
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            if (!$vvsUserData->toArray()) {
                return $this->failureMessage("Token mismatch");
            }
            $vvsRawRequest = $this->customDecrypt($request->X_KEY);
            $vvsValidationErrorData = $this->vvsHiraMasterListRequest->masterAPIInputValidation($vvsRawRequest);
            if (trim($vvsValidationErrorData) != "") {
                return $this->failureMessage($vvsValidationErrorData);
            }

            //PTW TYPE
            $vvsPtwtypes = $this->vvsPtwTypeService->getPtwTypeList();
            $vvsMasterData["VVSPtwTypes"] = PtwMstTypeResource::collection($vvsPtwtypes);

            //HIRA ACTIVITY
            $vvsHiraActivites = $this->vvsHiraActivityService->getHiraMstActivityList();
            $vvsMasterData["VVSHiraActivites"] = HiraMstActivityResource::collection($vvsHiraActivites);
            
            //HIRA DECLARATION
            $vvsHiraDeclarationsOne = $this->vvsHiraDeclService->getHiraInitialDeclListOne();
            $vvsMasterData["HiraDeclarationsOne"] = HiraMstDeclarationResource::collection($vvsHiraDeclarationsOne);

            $vvsHiraDeclarationsTwo = $this->vvsHiraDeclService->getHiraInitialDeclListTwo();
            $vvsMasterData["HiraDeclarationsTwo"] = HiraMstDeclarationResource::collection($vvsHiraDeclarationsTwo);

            $vvsHiraDeclarationsPopOne = $this->vvsHiraDeclService->getHiraInitialDeclListPopOne();
            $vvsMasterData["HiraDeclarationsPopOne"] = HiraMstDeclarationResource::collection($vvsHiraDeclarationsPopOne);

            //HIRA JOB
            $vvsHiraJobs = $this->vvsHiraJobService->getHiraJobList();
            $vvsMasterData["VVSHiraJobs"] = HiraMstJobResource::collection($vvsHiraJobs);

            //HIRA LIKELIHOOD
            $vvsHiraLikelihoods = $this->vvsHiraLikelihoodService->getHiraLikelihoodList();
            $vvsMasterData["VVSHiraLikelihoods"] = HiraMstLikelihoodResource::collection($vvsHiraLikelihoods);

            //HIRA RISK_RELATED
            $vvsHiraRiskRelateds = $this->vvsHiraRiskRelatedService->getHiraRiskRelatedList();
            $vvsMasterData["VVSHiraRiskRelateds"] = HiraMstRiskRelatedResource::collection($vvsHiraRiskRelateds);

            //HIRA SEVERITY
            $vvsHiraSeveritys = $this->vvsHiraSeverityService->getHiraSeverityList();
            $vvsMasterData["VVSHiraSeveritys"] = HiraMstSeverityResource::collection($vvsHiraSeveritys);

            //HIRA STAGE
            $vvsHiraStages = $this->vvsHiraStageService->getHiraStageList();
            $vvsMasterData["VVSHiraStages"] = HiraMstStageResource::collection($vvsHiraStages);

            //LOCATIONS
            $vvsHiraLocations = $this->vvsLocationService->getLocationList($vvsRawRequest);
            $vvsMasterData["VVSHiraLocations"] = HiraLocationResource::collection($vvsHiraLocations);

            //HIRA ACTION OWNER
            $vvsActionOwners = $this->vvsHiraActionOwnerService->getActionOwnerList($vvsRawRequest);
            $vvsMasterData["VVSActionOwners"] = HiraActionOwnerResource::collection($vvsActionOwners);

            
            return $this->successMessage( $vvsMasterData);
            
        }catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}