<?php

namespace App\Repositories\File;

use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use Illuminate\Validation\ValidationException;


class FileRepository implements FileInterface
{
    use EncDecService;

    public function fileUpload(Request $request)
    {
        try {
            $data = "";
            if ($request->hasFile('FILE')) {
                $file = $request->file('FILE');
                $requestedData = $request -> all();
                $sublocation = $requestedData["LOCATION"];

                if( $sublocation != "" ){
                    $destinationPath = public_path('uploads/'.$sublocation);
                    if (!file_exists($destinationPath)) {
                        mkdir($destinationPath, 0755, true);
                    }
                    $fileName = $file->getClientOriginalName();
                    
                    // Move the uploaded file to the destination path
                    $file->move($destinationPath, $fileName);
        
                    // Construct the file path
                    $data = 'uploads/'.$sublocation.'/' . $fileName;
                }
            }
            $isSecure = request()->secure();
            $protocol = "http://";
            if($isSecure){
                $protocol = "https://";
            }
             $output = ["RELATIVE_PATH" => $data,"BASE_PATH"=>$protocol.$request->getHost()."/public/"];
            // Return the file path
            return $this->successMessage($output);

        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}
