<?php

namespace App\Repositories\Dashboard;

// use App\Http\Requests\Dashboard\DashboardHiraCountRequest;

use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\Dashboard\DashboardTrainingServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\Dashboard\DashboardTrainingResource;
use App\Models\UserMapRole;

class DashboardTrainingRepository implements DashboardTrainingInterface
{
    use EncDecService;
    public $vvsDashboardTrainingServices;
    // public $vvsDashboardHiraCountRequest;
    public $vvsUserService;

    /**
     * MasterRiskRelatedRepository constructor.
     */

    public function __construct()
    {
        $this->vvsDashboardTrainingServices = new DashboardTrainingServices();
        // $this->vvsDashboardHiraCountRequest = new DashboardHiraCountRequest();
        $this->vvsUserService = new UserServices();
    }

    /**
     * @param Request $request
     * @return DashboardTrainingResource
     */
    public function dashboardTrainingCounts(Request $request)
    {
        try {
            if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
                return $this->failureMessage("Request pattern is not valid.");
            }
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            if (!$vvsUserData->toArray()) {
                return $this->failureMessage("Token mismatch");
            }
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            
            $dashboardTrainings = $this->vvsDashboardTrainingServices->getTrainingCountByLocation($requestData);
            // $output["TOTAL_NO"] = $dashboardTrainingTotalCount;

            $trainingData = [];
            //prd($dashboardTrainings);
        
            foreach ($dashboardTrainings as $training) {
                $locationId = $training->location->LOCATION_ID;
                $locationName = $training->location->LOCATION_NAME;
        
                // Apply the setTrainingStatus function to determine the status
                $status = $this->setTrainingStatus(
                    $training->TR_SCHEDULED_START_DATE,
                    $training->TR_SCHEDULED_END_DATE,
                    $training->STAGE_ID,
                    $training->TR_START_DATE,
                    $training->TR_END_DATE
                );

                 // Map the status to a specific count field
                $statusField = $status . "_count";

                // Initialize location data structure if not already set
                if (!isset($trainingData[$locationId])) {
                    $trainingData[$locationId] = [
                        "LOCATION_ID" => $locationId,
                        "LOCATION_NAME" => $locationName,
                        "over_due_count" => 0,
                        "scheduled_count" => 0,
                        "completed_count" => 0,
                        "completed_over_due_count" => 0,
                    ];
                }

                // Increment the appropriate count based on the status
                if (isset($trainingData[$locationId][$statusField])) {
                    $trainingData[$locationId][$statusField]++;
                }
            }
        
            //     // Initialize location data structure if not already set
            //     if (!isset($trainingData[$locationId])) {
            //         $trainingData[$locationId] = [
            //             "LOCATION_ID" => $locationId,
            //             "LOCATION_NAME" => $locationName,
            //             "TRAINING_COUNT" => []
            //         ];
            //     }
        
            //     // Initialize status count if not already set
            //     if (!isset($trainingData[$locationId]['TRAINING_COUNT'][$status])) {
            //         $trainingData[$locationId]['TRAINING_COUNT'][$status] = 0;
            //     }
        
            //     // Increment the count for this status
            //     $trainingData[$locationId]['TRAINING_COUNT'][$status]++;
            // }
        
            $outputData = [];
            foreach ($trainingData as $locationId => $data) {
                $outputData[] = $data;
            }
            $output["TrainingCountByLocation"] = $outputData;
            // $output["TrainingCountByLocation"] = $outputData;

            $dashboardTrainingMarksCount = $this->vvsDashboardTrainingServices->getDashboardParticipantMarksCount($requestData);
            $output["LOCATION_WISE_SCORE_SCALE"] = $dashboardTrainingMarksCount;

            $dashboardTrParticipantCount = $this->vvsDashboardTrainingServices->getDashboardParticipantCount($requestData);
            $output["LOCATION_WISE_PARTICIPANT"] = $dashboardTrParticipantCount;

            $dashboardTrainingStatusCountForCurrentMonth = $this->vvsDashboardTrainingServices->getTrainingStatusCountForCurrentMonth($requestData);
             
            $output["TrainingStatusCountForCurrentMonth"] = [];
            // $trainingStatusOutput = [];


    
            // Iterate over each training record and categorize by status
            foreach ($dashboardTrainingStatusCountForCurrentMonth as $training) {
            $locationId = $training->location->LOCATION_ID;
            $locationName = $training->location->LOCATION_NAME;

            // Determine status of the training
            $status = ($training->STAGE_ID == 2 && !empty($training->TR_END_DATE)) ? "Completed" : "Pending";

            // Map the status to a specific count field
            $statusField = strtolower(str_replace(' ', '-', $status)) . "_count";

            // Initialize location data structure if not already set
            if (!isset($output["TrainingStatusCountForCurrentMonth"][$locationId])) {
                $output["TrainingStatusCountForCurrentMonth"][$locationId] = [
                    "LOCATION_ID" => $locationId,
                    "LOCATION_NAME" => $locationName,
                    "completed_count" => 0,
                    "pending_count" => 0,
                ];
            }

            // Ensure $statusField is defined
            if (!isset($output["TrainingStatusCountForCurrentMonth"][$locationId][$statusField])) {
                $output["TrainingStatusCountForCurrentMonth"][$locationId][$statusField] = 0;
            }

            // Increment count for the status
            $output["TrainingStatusCountForCurrentMonth"][$locationId][$statusField]++;
            }

            // Convert the associative array into a numeric array
            $output["TrainingStatusCountForCurrentMonth"] = array_values($output["TrainingStatusCountForCurrentMonth"]);



            // // Iterate over each training record and categorize by status
            // foreach ($dashboardTrainingStatusCountForCurrentMonth as $training) {
            //     $locationId = $training->location->LOCATION_ID;
            //     $locationName = $training->location->LOCATION_NAME;

            //     // Determine status of the training
            //     $status = ($training->STAGE_ID == 2 && !empty($training->TR_END_DATE)) ? "Completed" : "Pending";

            //     // Initialize location data structure if not already set
            //     if (!isset($trainingStatusOutput[$locationId])) {
            //         $trainingStatusOutput[$locationId] = [
            //             "LOCATION_ID" => $locationId,
            //             "LOCATION_NAME" => $locationName,
            //             "TRAINING_COUNT" => []
            //         ];
            //     }

            //     // Increment count for the status
            //     if (!isset($trainingStatusOutput[$locationId]['TRAINING_COUNT'][$status])) {
            //         $trainingStatusOutput[$locationId]['TRAINING_COUNT'][$status] = 0;
            //     }
            //     $trainingStatusOutput[$locationId]['TRAINING_COUNT'][$status]++;
            // }

            // // Format the output
            // $formattedOutput = [];
            // foreach ($trainingStatusOutput as $data) {
            //     $formattedCount = [];
            //     foreach ($data['TRAINING_COUNT'] as $status => $count) {
            //         $formattedCount[] = ['status' => $status, 'count' => $count];
            //     }
            //     $data['TRAINING_COUNT'] = $formattedCount;
            //     $formattedOutput[] = $data;
            // }

            // $output["TrainingStatusCountForCurrentMonth"] = $formattedOutput;
            
            $year = date("Y");
            $month = date("m");

            $currentMonth = date("F, Y", strtotime($year . '-' . $month . '-01'));
            $output["CurrentMonth"] = $currentMonth;

            if (isset($requestData->START_DATE) && isset($requestData->END_DATE)) {
                $startDate = date('Y-m-d',strtotime($requestData->START_DATE));
                //$endDate = date('Y-m-d',strtotime($requestData->END_DATE));
                $currentMonth = date("F, Y", strtotime($startDate));
                $output["CurrentMonth"] = $currentMonth;
            }

            return $this->successMessage($output);
            
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    private function setTrainingStatus($scStartDate, $scEndDate, $stageId, $trStartDate = null, $trEndDate = null) {
        $date = date("Y-m-d");
        $status = "scheduled";  // Default status
    
        if ($stageId == 1) {
            $status = strtotime($scEndDate) < strtotime($date) ? "over_due" : "scheduled";
        } elseif ($stageId == 2) {
            if (strtotime($scStartDate) <= strtotime($trEndDate) && strtotime($scEndDate) >= strtotime($trEndDate)) {
                $status = "completed";
            } elseif (strtotime($scEndDate) < strtotime($trEndDate)) {
                $status = "completed_over_due";
            }
        }
    
        return $status;
    }
    
    
}