<?php

namespace App\Repositories\Dashboard;

use App\Http\Requests\Dashboard\DashboardPtwCountRequest;

use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\Dashboard\DashboardPtwServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\Dashboard\DashboardPtwResource;
use App\Models\UserMapRole;

class DashboardPtwRepository implements DashboardPtwInterface
{
    use EncDecService;
    public $vvsDashboardPtwServices;
    public $vvsDashboardPtwCountRequest;
    public $vvsUserService;

    /**
     * MasterRiskRelatedRepository constructor.
     */

    public function __construct()
    {
        $this->vvsDashboardPtwServices = new DashboardPtwServices();
        $this->vvsDashboardPtwCountRequest = new DashboardPtwCountRequest();
        $this->vvsUserService = new UserServices();
    }

    /**
     * @param Request $request
     * @return DashboardPtwResource
     */
    public function dashboardPtwCounts(Request $request)
    {
        try {
            if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
                return $this->failureMessage("Request pattern is not valid.");
            }
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            if (!$vvsUserData->toArray()) {
                return $this->failureMessage("Token mismatch");
            }
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            
            $dashboardPtwTotalCount = $this->vvsDashboardPtwServices->getDashboardPtwTotalCount($requestData);
            $output["TOTAL_NO"] = $dashboardPtwTotalCount;

            $dashboardPtwByTypeCount = $this->vvsDashboardPtwServices->getDashboardPtwByTypeCount($requestData);
            $filteredPtwCountByType = $dashboardPtwByTypeCount->filter(function ($item) {
                $item = (array)$item;
                return $item['PTW_COUNT'] !== null && $item['PTW_COUNT'] > 0;
            });
            $output["PtwCountByType"] = $filteredPtwCountByType->values()->all();

            $dashboardPtwByStageCount = $this->vvsDashboardPtwServices->getDashboardPtwByStageCount($requestData);
            $filteredPtwCountByStage = $dashboardPtwByStageCount->filter(function ($item) {
                $item = (array)$item;
                return $item['PTW_COUNT'] !== null && $item['PTW_COUNT'] > 0;
            });
            $output["PtwCountByStage"] = $filteredPtwCountByStage->values()->all();

            $dashboardPtwByLocationCount = $this->vvsDashboardPtwServices->getDashboardPtwByLocationCount($requestData);
            $filteredPtwCountByLocation = $dashboardPtwByLocationCount->filter(function ($item) {
                $item = (array)$item;
                return $item['PTW_COUNT'] !== null && $item['PTW_COUNT'] > 0;
            })->map(function ($item) {
                $value = $item->LOCATION_NAME;
                $details = collect([$item->BUILDING, $item->FLOOR, $item->WING, $item->DEPARTMENT, $item->CHECKLIST, $item->QR_CODE])
                    ->filter() // Remove any null or empty strings
                    ->implode(' | '); // Combine with ' | ' as the separator
        
                if (!empty($details)) {
                    $value .= ' | ' . $details;
                }
        
                return [
                    'LOCATION_ID' => $item->LOCATION_ID,
                    'LOCATION_NAME' => $value,
                    'PTW_COUNT' => $item->PTW_COUNT
                ];
            });
            $output["PtwCountByLocation"] = $filteredPtwCountByLocation->values()->all();

            return $this->successMessage($output);
            
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}