<?php

namespace App\Repositories\Dashboard;


use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\Dashboard\DashboardObservationServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\Dashboard\DashboardObservationResource;
use App\Models\UserMapRole;

class DashboardObservationRepository implements DashboardObservationInterface
{
    use EncDecService;
    public $vvsDashboardObsServices;
    public $vvsUserService;

    /**
     * DashboardObservationRepository constructor.
     */

    public function __construct()
    {
        $this->vvsDashboardObsServices = new DashboardObservationServices();
        $this->vvsUserService = new UserServices();
    }

    /**
     * @param Request $request
     * @return DashboardTrainingResource
     */
    public function dashboardObservationCounts(Request $request)
    {
        try {
            if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
                return $this->failureMessage("Request pattern is not valid.");
            }
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            if (!$vvsUserData->toArray()) {
                return $this->failureMessage("Token mismatch");
            }
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $totalObsCount = $this->vvsDashboardObsServices->getObsTotalCount($requestData);
            $output["TOTAL_OBS_COUNT"] = $totalObsCount;

            $stageWiseObsCount = $this->vvsDashboardObsServices->getDashboardObsByStageCount($requestData);
            $filteredstageWiseObsCount = $stageWiseObsCount->filter(function ($item) {
                $item = (array)$item;
                return $item['OBSERVATION_COUNT'] !== null && $item['OBSERVATION_COUNT'] > 0;
            });
            $output["STAGE_WISE_OBS_COUNT"] = $filteredstageWiseObsCount->values()->all();

            $typeWiseObsCount = $this->vvsDashboardObsServices->getDashboardObsByTypeCount($requestData);
            $filteredtypeWiseObsCount = $typeWiseObsCount->filter(function ($item) {
                $item = (array)$item;
                return $item['OBSERVATION_COUNT'] !== null && $item['OBSERVATION_COUNT'] > 0;
            });
            $output["TYPE_WISE_OBS_COUNT"] = $filteredtypeWiseObsCount->values()->all();

            $riskWiseObsCount = $this->vvsDashboardObsServices->getDashboardObsByRiskCount($requestData);
            $output["RISK_MATRIX_WISE_OBS_COUNT"] = $riskWiseObsCount;

            $high = 0;
            $medium = 0;
            $low = 0;
            $rislrating = array();
            foreach($riskWiseObsCount as $value){
                if(strtoupper($value->risk_factor) == "A1" || strtoupper($value->risk_factor) == "A2" || strtoupper($value->risk_factor) == "B1"){
                        $high+=$value->observation_count;
                }elseif(strtoupper($value->risk_factor) == "A3" || strtoupper($value->risk_factor) == "B2" || strtoupper($value->risk_factor) == "C1"){
                    $medium+=$value->observation_count;
                }elseif(strtoupper($value->risk_factor) == "B3" || strtoupper($value->risk_factor) == "C2" || strtoupper($value->risk_factor) == "C3"){
                    $low+=$value->observation_count;
                }
            }
            $rislrating = [
                [
                    "RISK_RATING_STAGE_ID" => 1,
                    "RISK_RATING_STAGE_NAME" => "High",
                    "RISK_RATING_COLOR" => "#ff0a00",
                    "COUNT" => $high
                ],
                [
                    "RISK_RATING_STAGE_ID" => 2,
                    "RISK_RATING_STAGE_NAME" => "Medium",
                    "RISK_RATING_COLOR" => "#ffff00",
                    "COUNT" => $medium
                ],
                [
                    "RISK_RATING_STAGE_ID" => 3,
                    "RISK_RATING_STAGE_NAME" => "Low",
                    "RISK_RATING_COLOR" => "#92d050",
                    "COUNT" => $low
                ]
            ];
            $output["RISK_RATING_WISE_OBS_COUNT"] = $rislrating;

            return $this->successMessage($output);
            
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
           
        }
    }
}