<?php

namespace App\Repositories\Dashboard;

use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\Dashboard\DashboardInspectionServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\Dashboard\DashboardInspectionResource;
use App\Models\UserMapRole;

class DashboardInspectionRepository implements DashboardInspectionInterface
{
    use EncDecService;
    public $vvsDashboardInspServices;
    public $vvsDashboardInspCountRequest;
    public $vvsUserService;

    /**
     * MasterRiskRelatedRepository constructor.
     */

    public function __construct()
    {
        $this->vvsDashboardInspServices = new DashboardInspectionServices();
        $this->vvsUserService = new UserServices();
    }

    /**
     * @param Request $request
     * @return DashboardInspectionResource
     */
    public function dashboardInspectionCounts(Request $request)
    {
        try {
            if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
                return $this->failureMessage("Request pattern is not valid.");
            }
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            if (!$vvsUserData->toArray()) {
                return $this->failureMessage("Token mismatch");
            }
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            
            $dashboardInspTotalCount = $this->vvsDashboardInspServices->getDashboardInspectionTotalCount($requestData);
            $output["TOTAL_NO"] = $dashboardInspTotalCount;
            
            $dashboardInspTypeCount = $this->vvsDashboardInspServices->getDashboardInspectionByTypeCount($requestData);
            $filteredInspTypeCount = $dashboardInspTypeCount->filter(function ($item) {
                $item = (array)$item;
                return $item['INSPECTION_COUNT'] !== null && $item['INSPECTION_COUNT'] > 0;
            });
            $output["TYPE_WISE_INSPECTION_COUNT"] = $filteredInspTypeCount->values()->all();

            $dashboardInspOptionCount = $this->vvsDashboardInspServices
                                        ->getDashboardInspChecklistOptionCount($requestData);
            $complience = 0;
            $noncomplience = 0;
            $comparr = array();
            foreach ($dashboardInspOptionCount as $value){
                if (strtoupper($value->CHECKLIST_OPTION_NAME) == "YES"){
                    $complience+=$value->option_count;
                }else {
                    $noncomplience+=$value->option_count;
                }
            }
            $comparr = [
                [
                    "COMPLIENCE_NAME" => "Complence",
                    "COUNT" => $complience
                ],
                [
                    "COMPLIENCE_NAME" => "Non-Complence",
                    "COUNT" => $noncomplience
                ]
            ];
            $output["COMPLIENCE_WISE_COUNT"] = $comparr;

            $dashboardInspByLocationCount = $this->vvsDashboardInspServices->getDashboardInspectionByLocationCount($requestData);
            $filteredInspCountByLocation = $dashboardInspByLocationCount->filter(function ($item) {
                $item = (array)$item;
                return $item['INSPECTION_COUNT'] !== null && $item['INSPECTION_COUNT'] > 0;
            })->map(function ($item) {
                $value = $item->LOCATION_NAME;
                $details = collect([$item->BUILDING, $item->FLOOR, $item->WING, $item->DEPARTMENT, $item->CHECKLIST, $item->QR_CODE])
                    ->filter() // Remove any null or empty strings
                    ->implode(' | '); // Combine with ' | ' as the separator
        
                if (!empty($details)) {
                    $value .= ' | ' . $details;
                }
        
                return [
                    'LOCATION_ID' => $item->LOCATION_ID,
                    'LOCATION_NAME' => $value,
                    'INSPECTION_COUNT' => $item->INSPECTION_COUNT
                ];
            });
            $output["LOCATION_WISE_INSPECTION_COUNT"] = $filteredInspCountByLocation->values()->all();

            return $this->successMessage($output);
            
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}