<?php

namespace App\Repositories\Dashboard;

// use App\Http\Requests\Dashboard\DashboardHiraCountRequest;

use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\Dashboard\DashboardHiraServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\Dashboard\DashboardHiraResource;
use App\Models\UserMapRole;

class DashboardHiraRepository implements DashboardHiraInterface
{
    use EncDecService;
    public $vvsDashboardHiraServices;
    // public $vvsDashboardHiraCountRequest;
    public $vvsUserService;

    /**
     * MasterRiskRelatedRepository constructor.
     */

    public function __construct()
    {
        $this->vvsDashboardHiraServices = new DashboardHiraServices();
        // $this->vvsDashboardHiraCountRequest = new DashboardHiraCountRequest();
        $this->vvsUserService = new UserServices();
    }

    /**
     * @param Request $request
     * @return DashboardHiraResource
     */
    public function dashboardHiraCounts(Request $request)
    {
        try {
            if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
                return $this->failureMessage("Request pattern is not valid.");
            }
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            if (!$vvsUserData->toArray()) {
                return $this->failureMessage("Token mismatch");
            }
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            
            $dashboardHiraTotalCount = $this->vvsDashboardHiraServices->getDashboardHiraTotalCount($requestData);
            $output["TOTAL_NO"] = $dashboardHiraTotalCount;


            $dashboardHiraByStageCount = $this->vvsDashboardHiraServices->getDashboardHiraByStageCount($requestData);
            $filteredHiraCountByStage = $dashboardHiraByStageCount->filter(function ($item) {
                $item = (array)$item;
                return $item['HIRA_COUNT'] !== null && $item['HIRA_COUNT'] > 0;
            });
            $output["HiraCountByStage"] = $filteredHiraCountByStage->values()->all();


            $dashboardActivityByJobCount = $this->vvsDashboardHiraServices
                                            ->getDashboardActivityByJobCount($requestData);
            $filteredActivityCountByJob = $dashboardActivityByJobCount->filter(function ($item) {
                $item = (array)$item;
                return $item['HIRA_ACTIVITY_COUNT'] !== null && $item['HIRA_ACTIVITY_COUNT'] > 0;
            });
            $output["ActivityCountByJob"] = $filteredActivityCountByJob->values()->all();


            $dashboardActivityByRiskRatingCount = $this->vvsDashboardHiraServices
                                            ->getDashboardActivityByRiskRatingCount($requestData);
            $severityMapping = [
                1 => ['name' => 'High', 'color' => '#ff0a00'],
                2 => ['name' => 'Medium', 'color' => '#ffff00'],
                3 => ['name' => 'Low', 'color' => '#92d050'],
            ];
            // prd($dashboardActivityByRiskRatingCount);
            $filteredActivityCountByRiskRating = $dashboardActivityByRiskRatingCount
            ->map(function ($item) use ($severityMapping) {
                $item = (array)$item;
                if ($item['HIRA_ACTIVITY_COUNT'] !== null && $item['HIRA_ACTIVITY_COUNT'] > 0) {
                    $severityId = $item['ORD_BY_SEVERITY'];
                    return [
                        'RISK_RATING_STAGE_ID' => $severityId,
                        'RISK_RATING_STAGE_NAME' => $severityMapping[$severityId]['name'] ?? 'Unknown',
                         // Handling unknown severity IDs
                        'RISK_RATING_COLOR' => $severityMapping[$severityId]['color'] ?? '#FFFFFF',
                         // Default color for unknown severity
                        'HIRA_ACTIVITY_COUNT' => $item['HIRA_ACTIVITY_COUNT']
                    ];
                }
                return null;
            })->filter()->values()->all();
            $output["ActivityCountByRiskRating"] = $filteredActivityCountByRiskRating;


            
            $dashboardActivityByRiskMatrixCount = $this->vvsDashboardHiraServices
                                                ->getDashboardActivityByRiskMatrix($requestData);
            // prd($dashboardActivityByRiskMatrixCount);
            $filteredActivityCountByRiskMatrix = $dashboardActivityByRiskMatrixCount->filter(function ($item) {
                return $item->HIRA_ACTIVITY_COUNT !== null && $item->HIRA_ACTIVITY_COUNT > 0;
            })->map(function ($item) {
                $itemArray = (array) $item;
                $riskFactor = strtoupper($itemArray['SEVERITY_NAME']) . $itemArray['LIKELIHOOD_NAME'];
                $itemArray['RISK_FACTOR'] = $riskFactor;
                return $itemArray;
            });
            $output["ActivityCountByRiskMatrix"] = $filteredActivityCountByRiskMatrix->values()->all();


            // $dashboardPtwByLocationCount = $this->vvsDashboardPtwServices->getDashboardPtwByLocationCount($requestData);
            // $filteredPtwCountByLocation = $dashboardPtwByLocationCount->filter(function ($item) {
            //     $item = (array)$item;
            //     return $item['HIRA_COUNT'] !== null && $item['HIRA_COUNT'] > 0;
            // })->map(function ($item) {
            //     $value = $item->LOCATION_NAME;
            //     $details = collect([$item->BUILDING, $item->FLOOR, $item->WING, $item->DEPARTMENT, $item->CHECKLIST, $item->QR_CODE])
            //         ->filter() // Remove any null or empty strings
            //         ->implode(' | '); // Combine with ' | ' as the separator
        
            //     if (!empty($details)) {
            //         $value .= ' | ' . $details;
            //     }
        
            //     return [
            //         'LOCATION_ID' => $item->LOCATION_ID,
            //         'LOCATION_NAME' => $value,
            //         'HIRA_COUNT' => $item->HIRA_COUNT
            //     ];
            // });
            // $output["PtwCountByLocation"] = $filteredPtwCountByLocation->values()->all();

            return $this->successMessage($output);
            
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}