<?php

namespace App\Repositories\Chart;

use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\Chart\ChartPtwServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\Dashboard\ChartPtwResource;
use App\Models\UserMapRole;

class ChartPtwRepository implements ChartPtwInterface
{
    use EncDecService;
    public $vvsChartPtwServices;
    public $vvsChartPtwCountRequest;
    public $vvsUserService;

    /**
     * MasterRiskRelatedRepository constructor.
     */

    public function __construct()
    {
        $this->vvsChartPtwServices = new ChartPtwServices();        
        $this->vvsUserService = new UserServices();
    }

    /**
     * @param Request $request
     * @return DashboardPtwResource
     */
    public function chartPtwCounts(Request $request)
    {
        try {
            if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
                return $this->failureMessage("Request pattern is not valid.");
            }
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            if (!$vvsUserData->toArray()) {
                return $this->failureMessage("Token mismatch");
            }
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;

            $chartPtwTotalCount = $this->vvsChartPtwServices->getChartPtwTotalCount($requestData);
            $output["TOTAL_PTW_COUNT"] = $chartPtwTotalCount;

            $chartPtwByTypeCount = $this->vvsChartPtwServices->getChartPtwByTypeCount($requestData);
            $chartBarData = $this->setBarChartData($chartPtwByTypeCount);
            $output["OVERALL_TYPE_WISE_PTW_COUNT"] = $chartBarData;

            $chartOpenPtwByTypeCount = $this->vvsChartPtwServices->getChartOpenPtwByTypeCount($requestData);
            $chartBarDataOpen = $this->setBarChartData($chartOpenPtwByTypeCount);
            $output["TYPE_WISE_OPEN_PTW_COUNT"] = $chartBarDataOpen;

            $overviewPtwByTypeCount = $this->vvsChartPtwServices->getChartPtwByStageOverviewCount($requestData);
            $chartPieDataOverview = $this->setPieChartData($overviewPtwByTypeCount);
            $output["OVERVIEW_PTW_COUNT"] = $chartPieDataOverview;
            
            return $this->successMessage($output);
            
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    private function setBarChartData($barChartData){
        $barChartArr = array();
        if(!empty($barChartData)){
            foreach ($barChartData as $key => $value) {
                $barChartArr['labels'][] = $value->TYPE_NAME;
                $barChartArr['data'][] = $value->PTW_COUNT??0;
            }
        }
        
        $returnset['labels'] = $barChartArr['labels'];
        $returnset['datasets'][0]['data'] = $barChartArr['data'];
        $returnset['datasets'][0]['backgroundColor'] = '#e60000';
        $returnset['datasets'][0]['hoverBackgroundColor'] = '#e60000';
        $returnset['datasets'][0]['barThickness'] = 8;

        return $returnset;
    }

    private function setPieChartData($pieChartData){
        $pieChartArr = array();
        $pieChartArr['data'][0]=0;
        $pieChartArr['data'][1]=0;
        $pieChartArr['data'][2]=0;
        if(!empty($pieChartData)){
            foreach ($pieChartData as $key => $value) {
                $pieChartArr['data'][$value->ptw_status]+= $value->ptw_count??0;
            }
        }
        
        $returnset['labels'] = ['Opened','Suspended','Closed'];
        $returnset['datasets'][0]['data'] = $pieChartArr['data'];
        $returnset['datasets'][0]['backgroundColor'] = ['#c4c7c9', '#333333', '#e60000'];
        $returnset['datasets'][0]['hoverBackgroundColor'] = ['#c4c7c9', '#333333', '#e60000'];
        $returnset['datasets'][0]['barThickness'] = 8;

        return $returnset;
    }
}