<?php

namespace App\Repositories\Chart;

use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\Chart\ChartObservationServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\Chart\ChartObservationResource;
use App\Models\UserMapRole;

class ChartObservationRepository implements ChartObservationInterface
{
    use EncDecService;
    public $vvsChartObsServices;
    public $vvsChartObsCountRequest;
    public $vvsUserService;

    /**
     * MasterRiskRelatedRepository constructor.
     */

    public function __construct()
    {
        $this->vvsChartObsServices = new ChartObservationServices();
        $this->vvsUserService = new UserServices();
    }

    /**
     * @param Request $request
     * @return DashboardPtwResource
     */
    public function chartObservationCounts(Request $request)
    {
        try {
            if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
                return $this->failureMessage("Request pattern is not valid.");
            }
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            if (!$vvsUserData->toArray()) {
                return $this->failureMessage("Token mismatch");
            }
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;

            $totalObsCount = $this->vvsChartObsServices->getObsTotalCount($requestData);
            $output["TOTAL_OBS_COUNT"] = $totalObsCount;

            $chartObsByTimeCount = $this->vvsChartObsServices->getChartObservationCountByTime($requestData);
            $chartObsComData = $this->setComplyingStatusPieChartData($chartObsByTimeCount);
            $output["COMPLIANCE_OVERVIEW_OBSERVATION_COUNT"] = $chartObsComData;
            
            $chartComByTypeCount = $this->vvsChartObsServices->getChartComplianceCountByType($requestData);
            $chartObsComDatabByType = $this->setComplianceStatusBarChartData($chartComByTypeCount);
            $output["TYPE_WISE_COMPLIANCE_OBSERVATION_COUNT"] = $chartObsComDatabByType;
            

            $chartObsByTypeCount = $this->vvsChartObsServices->getChartObsByTypeCount($requestData);
            $chartObsTypeBarData = $this->setBarChartData($chartObsByTypeCount);
            $output["OVERALL_TYPE_WISE_OBSERVATION_COUNT"] = $chartObsTypeBarData;
            

            $chartObsRiskMatrixCount = $this->vvsChartObsServices->getChartObsByRiskCount($requestData);
            $chartObsRiskData = $this->setRiskMatrixPieChartData($chartObsRiskMatrixCount);
            $output["RISK_RATING_OVERVIEW_OBSERVATION_COUNT"] = $chartObsRiskData;
            
            $chartObsRiskMatrixCountByType = $this->vvsChartObsServices->getChartObsByRiskCountByType($requestData);
            $chartObsRiskDatabByType = $this->setRiskMatrixBarChartData($chartObsRiskMatrixCountByType);
            $output["TYPE_WISE_RISK_RATING_OBSERVATION_COUNT"] = $chartObsRiskDatabByType;

            return $this->successMessage($output);
            
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    private function setBarChartData($barChartData){
        $barChartArr = array();
        if(!empty($barChartData)){
            foreach ($barChartData as $key => $value) {
                $barChartArr['labels'][] = $value->OBS_TYPE_NAME;
                $barChartArr['data'][] = $value->OBSERVATION_COUNT??0;
            }
        }
        
        $returnset['labels'] = $barChartArr['labels'];
        $returnset['datasets'][0]['data'] = $barChartArr['data'];
        $returnset['datasets'][0]['backgroundColor'] = '#e60000';
        $returnset['datasets'][0]['hoverBackgroundColor'] = '#e60000';
        $returnset['datasets'][0]['barThickness'] = 8;

        return $returnset;
    }

    private function setComplyingStatusPieChartData($pieChartData){
        $pieChartArr = array();
        $pieChartArr['data'][0]=0;
        $pieChartArr['data'][1]=0;
        $pieChartArr['data'][2]=0;
        if(!empty($pieChartData)){
            foreach ($pieChartData as $key => $value) {
                if(strtoupper($value->observation_end_status) == 1){
                    $pieChartArr['data'][0]+=$value->observation_count??0;
                }elseif(strtoupper($value->observation_end_status) == 2){
                    $pieChartArr['data'][1]+=$value->observation_count??0;
                }elseif(strtoupper($value->observation_end_status) == 3){
                    $pieChartArr['data'][2]+=$value->observation_count??0;
                }
            }
        }
        
        $returnset['labels'] = ['Compliance Overdue','Compliant','Under Compliance'];
        $returnset['datasets'][0]['data'] = $pieChartArr['data'];
        $returnset['datasets'][0]['backgroundColor'] = ['#c4c7c9', '#333333', '#e60000'];
        $returnset['datasets'][0]['hoverBackgroundColor'] = ['#c4c7c9', '#333333', '#e60000'];
        //$returnset['datasets'][0]['barThickness'] = 8;

        return $returnset;
    }

    

    private function setRiskMatrixPieChartData($pieChartData){
        $pieChartArr = array();
        $pieChartArr['data'][0]=0;
        $pieChartArr['data'][1]=0;
        $pieChartArr['data'][2]=0;
        if(!empty($pieChartData)){
            foreach ($pieChartData as $key => $value) {
                if(strtoupper($value->risk_factor) == "A1" || strtoupper($value->risk_factor) == "A2" || strtoupper($value->risk_factor) == "B1"){
                    $pieChartArr['data'][0]+=$value->observation_count??0;
                }elseif(strtoupper($value->risk_factor) == "A3" || strtoupper($value->risk_factor) == "B2" || strtoupper($value->risk_factor) == "C1"){
                    $pieChartArr['data'][1]+=$value->observation_count??0;
                }elseif(strtoupper($value->risk_factor) == "B3" || strtoupper($value->risk_factor) == "C2" || strtoupper($value->risk_factor) == "C3"){
                    $pieChartArr['data'][2]+=$value->observation_count??0;
                }
            }
        }
        
        $returnset['labels'] = ['High','Medium','Low'];
        $returnset['datasets'][0]['data'] = $pieChartArr['data'];
        $returnset['datasets'][0]['backgroundColor'] = ['#c4c7c9', '#333333', '#e60000'];
        $returnset['datasets'][0]['hoverBackgroundColor'] = ['#c4c7c9', '#333333', '#e60000'];
        //$returnset['datasets'][0]['barThickness'] = 8;

        return $returnset;
    }

    private function setRiskMatrixBarChartData($pieChartData){
        $barChartArr = array();
        $labelArr = array();
        if(!empty($pieChartData)){
            foreach ($pieChartData as $key => $value) {
                $barChartArr[$value->OBS_TYPE_ID]['labels'] = $value->OBS_TYPE_NAME;
                $barChartArr[$value->OBS_TYPE_ID]['high'][] = 0;
                $barChartArr[$value->OBS_TYPE_ID]['medium'][] = 0;
                $barChartArr[$value->OBS_TYPE_ID]['low'][] = 0;
                if(strtoupper($value->RISK_FACTOR) == "A1" || strtoupper($value->RISK_FACTOR) == "A2" || strtoupper($value->RISK_FACTOR) == "B1"){
                    $barChartArr[$value->OBS_TYPE_ID]['high'][]=$value->OBSERVATION_COUNT??0;
                }elseif(strtoupper($value->RISK_FACTOR) == "A3" || strtoupper($value->RISK_FACTOR) == "B2" || strtoupper($value->RISK_FACTOR) == "C1"){
                    $barChartArr[$value->OBS_TYPE_ID]['medium'][]=$value->OBSERVATION_COUNT??0;
                }elseif(strtoupper($value->RISK_FACTOR) == "B3" || strtoupper($value->RISK_FACTOR) == "C2" || strtoupper($value->RISK_FACTOR) == "C3"){
                    $barChartArr[$value->OBS_TYPE_ID]['low'][]=$value->OBSERVATION_COUNT??0;
                }
            }
        }
        foreach ($barChartArr as $key => $value) {
            $labelArr['labels'][] = $value['labels'];
            $labelArr['high'][] = array_sum($value['high']);
            $labelArr['medium'][] = array_sum($value['medium']);
            $labelArr['low'][] = array_sum($value['low']);
        }
        $hghArray['data'] = $labelArr['high'];
        $hghArray['label'] = 'High';
        $hghArray['backgroundColor'] = ['#e60800'];
        $hghArray['hoverBackgroundColor'] = ['#e60800'];
        $hghArray['barThickness'] = 8;
        $hghArray['stack'] = 'a';

        $mediumArray['data'] = $labelArr['medium'];
        $mediumArray['label'] = 'Medium';
        $mediumArray['backgroundColor'] = ['#333333'];
        $mediumArray['hoverBackgroundColor'] = ['#333333'];
        $mediumArray['barThickness'] = 8;
        $mediumArray['stack'] = 'a';

        $lowArray['data'] = $labelArr['low'];
        $lowArray['label'] = 'Low';
        $lowArray['backgroundColor'] = ['#808080'];
        $lowArray['hoverBackgroundColor'] = ['#808080'];
        $lowArray['barThickness'] = 8;
        $lowArray['stack'] = 'a';

        
        $returnset['labels'] = $labelArr['labels'];
        $returnset['datasets'][] = $lowArray;
        $returnset['datasets'][] = $mediumArray;
        $returnset['datasets'][]=$hghArray;
        return $returnset;
    }

    private function setComplianceStatusBarChartData($pieChartData){
        $barChartArr = array();
        $labelArr = array();
        if(!empty($pieChartData)){
            foreach ($pieChartData as $key => $value) {
                $barChartArr[$value->OBS_TYPE_ID]['labels'] = $value->OBS_TYPE_NAME;
                $barChartArr[$value->OBS_TYPE_ID]['overdue'][] = 0;
                $barChartArr[$value->OBS_TYPE_ID]['compliant'][] = 0;
                $barChartArr[$value->OBS_TYPE_ID]['undercomplance'][] = 0;
                if(strtoupper($value->OBSERVATION_END_STATUS) == 1){
                    $barChartArr[$value->OBS_TYPE_ID]['overdue'][]=$value->OBSERVATION_COUNT??0;
                }elseif(strtoupper($value->OBSERVATION_END_STATUS) == 2){
                    $barChartArr[$value->OBS_TYPE_ID]['compliant'][]=$value->OBSERVATION_COUNT??0;
                }elseif(strtoupper($value->OBSERVATION_END_STATUS) == 3){
                    $barChartArr[$value->OBS_TYPE_ID]['undercomplance'][]=$value->OBSERVATION_COUNT??0;
                }
            }
        }
        foreach ($barChartArr as $key => $value) {
            $labelArr['labels'][] = $value['labels'];
            $labelArr['overdue'][] = array_sum($value['overdue']);
            $labelArr['compliant'][] = array_sum($value['compliant']);
            $labelArr['undercomplance'][] = array_sum($value['undercomplance']);
        }
        $hghArray['data'] = $labelArr['overdue'];
        $hghArray['label'] = 'Compliance Overdue';
        $hghArray['backgroundColor'] = ['#e60800'];
        $hghArray['hoverBackgroundColor'] = ['#e60800'];
        $hghArray['barThickness'] = 8;
        $hghArray['stack'] = 'a';

        $mediumArray['data'] = $labelArr['compliant'];
        $mediumArray['label'] = 'Compliant';
        $mediumArray['backgroundColor'] = ['#333333'];
        $mediumArray['hoverBackgroundColor'] = ['#333333'];
        $mediumArray['barThickness'] = 8;
        $mediumArray['stack'] = 'a';

        $lowArray['data'] = $labelArr['undercomplance'];
        $lowArray['label'] = 'Under Compliance';
        $lowArray['backgroundColor'] = ['#808080'];
        $lowArray['hoverBackgroundColor'] = ['#808080'];
        $lowArray['barThickness'] = 8;
        $lowArray['stack'] = 'a';

        
        $returnset['labels'] = $labelArr['labels'];
        $returnset['datasets'][] = $lowArray;
        $returnset['datasets'][] = $mediumArray;
        $returnset['datasets'][]=$hghArray;
        return $returnset;
    }
}