<?php

namespace App\Repositories\Chart;

use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\Chart\ChartInspectionServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\Chart\ChartInspectionResource;
use App\Models\UserMapRole;

class ChartInspectionRepository implements ChartInspectionInterface
{
    use EncDecService;
    public $vvsChartInspServices;
    public $vvsChartInspCountRequest;
    public $vvsUserService;

    /**
     * MasterRiskRelatedRepository constructor.
     */

    public function __construct()
    {
        $this->vvsChartInspServices = new ChartInspectionServices();
        $this->vvsUserService = new UserServices();
    }

    /**
     * @param Request $request
     * @return DashboardPtwResource
     */
    public function chartInspectionCounts(Request $request)
    {
        try {
            if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
                return $this->failureMessage("Request pattern is not valid.");
            }
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            if (!$vvsUserData->toArray()) {
                return $this->failureMessage("Token mismatch");
            }
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;

            $chartInspTotalCount = $this->vvsChartInspServices->getChartInspectionTotalCount($requestData);
            $output["TOTAL_NO"] = $chartInspTotalCount;

            $chartInspByTypeCount = $this->vvsChartInspServices->getChartInspectionByTypeCount($requestData);
            $chartInspTypeBarData = $this->setBarChartData($chartInspByTypeCount);
            $output["OVERALL_TYPE_WISE_INSPECTION_COUNT"] = $chartInspTypeBarData;
            
            $chartInsNCpByTypeCount = $this->vvsChartInspServices->getChartNonCompInspectionByTypeCount($requestData);
            $chartInspNcTypeBarData = $this->setBarChartData($chartInsNCpByTypeCount);
            $output["TYPE_WISE_NON_COMPLIENCE_COUNT"] = $chartInspNcTypeBarData;

            $chartInspChkOptionCount = $this->vvsChartInspServices->getChartInspChecklistOptionCount($requestData);
            $chartInspChkOptPieData = $this->setComplientPieChartData($chartInspChkOptionCount);
            $output["OVERVIEW_COMPLIENCE_COUNT"] = $chartInspChkOptPieData;

            $chartInspChkOptionCountByType = $this->vvsChartInspServices->getChartCompInspectionByTypeCount($requestData);
            $chartComLienceByType = $this->setTypeComplienceBarChartData($chartInspChkOptionCountByType);
            $output["TYPE_WISE_COMPLIENCE_COUNT"] = $chartComLienceByType;
            //prd($chartInspChkOptionCountByType);
            
            return $this->successMessage($output);
            
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    private function setBarChartData($barChartData){
        $barChartArr = array();
        if(!empty($barChartData)){
            foreach ($barChartData as $key => $value) {
                $barChartArr['labels'][] = $value->INSP_TYPE_NAME;
                $barChartArr['data'][] = $value->INSPECTION_COUNT??0;
            }
        }
        
        $returnset['labels'] = $barChartArr['labels'];
        $returnset['datasets'][0]['data'] = $barChartArr['data'];
        $returnset['datasets'][0]['backgroundColor'] = '#e60000';
        $returnset['datasets'][0]['hoverBackgroundColor'] = '#e60000';
        $returnset['datasets'][0]['barThickness'] = 8;

        return $returnset;
    }

    

    private function setComplientPieChartData($pieChartData){
        $pieChartArr = array();
        $pieChartArr['data'][0]=0;
        $pieChartArr['data'][1]=0;
        $pieChartArr['data'][2]=0;
        if(!empty($pieChartData)){
            foreach ($pieChartData as $key => $value) {
                if(strtoupper($value->CHECKLIST_OPTION_NAME) == "NO"){
                    $pieChartArr['data'][0]+=$value->option_count??0;
                }elseif(strtoupper($value->CHECKLIST_OPTION_NAME) == "YES"){
                    $pieChartArr['data'][1]+=$value->option_count??0;
                }elseif(strtoupper($value->CHECKLIST_OPTION_NAME) == "NA"){
                    $pieChartArr['data'][2]+=$value->option_count??0;
                }
            }
        }
        
        $returnset['labels'] = ['Non Complient','Complient','NA'];
        $returnset['datasets'][0]['data'] = $pieChartArr['data'];
        $returnset['datasets'][0]['backgroundColor'] = ['#c4c7c9', '#333333', '#e60000'];
        $returnset['datasets'][0]['hoverBackgroundColor'] = ['#c4c7c9', '#333333', '#e60000'];
        //$returnset['datasets'][0]['barThickness'] = 8;

        return $returnset;
    }

    private function setTypeComplienceBarChartData($pieChartData){
        $barChartArr = array();
        $labelArr = array();
        if(!empty($pieChartData)){
            foreach ($pieChartData as $key => $value) {
                $barChartArr[$value->INSP_TYPE_ID]['labels'] = $value->INSP_TYPE_NAME;
                $barChartArr[$value->INSP_TYPE_ID]['yes'][]=0;
                $barChartArr[$value->INSP_TYPE_ID]['no'][]=0;
                if(strtoupper($value->CHECKLIST_OPTION_NAME) == "YES"){
                    $barChartArr[$value->INSP_TYPE_ID]['yes'][]=$value->INSPECTION_COUNT??0;
                }elseif(strtoupper($value->CHECKLIST_OPTION_NAME) == "NO"){
                    $barChartArr[$value->INSP_TYPE_ID]['no'][]=$value->INSPECTION_COUNT??0;
                }
            }
        }
        foreach ($barChartArr as $key => $value) {
            $labelArr['labels'][] = $value['labels'];
            $labelArr['yes'][] = array_sum($value['yes']);
            $labelArr['no'][] = array_sum($value['no']);            
        }
        $comArray['data'] = $labelArr['yes'];
        $comArray['label'] = 'COMPLIENCE';
        $comArray['backgroundColor'] = ['#e60800'];
        $comArray['hoverBackgroundColor'] = ['#e60800'];
        $comArray['barThickness'] = 8;
        //$comArray['stack'] = 'a';

        $ncArray['data'] = $labelArr['no'];
        $ncArray['label'] = 'NON-COMPLIENCE';
        $ncArray['backgroundColor'] = ['#333333'];
        $ncArray['hoverBackgroundColor'] = ['#333333'];
        $ncArray['barThickness'] = 8;
        //$ncArray['stack'] = 'a';

        $returnset['labels'] = $labelArr['labels'];
        $returnset['datasets'][] = $comArray;
        $returnset['datasets'][] = $ncArray;
        return $returnset;
    }
}