<?php

namespace App\Repositories\Chart;

use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\Chart\ChartHiraServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\Chart\ChartHiraResource;
use App\Models\UserMapRole;

class ChartHiraRepository implements ChartHiraInterface
{
    use EncDecService;
    public $vvsChartHiraServices;
    public $vvsChartHiraCountRequest;
    public $vvsUserService;

    /**
     * MasterRiskRelatedRepository constructor.
     */

    public function __construct()
    {
        $this->vvsChartHiraServices = new ChartHiraServices();        
        $this->vvsUserService = new UserServices();
    }

    /**
     * @param Request $request
     * @return DashboardPtwResource
     */
    public function chartHiraCounts(Request $request)
    {
        try {
            if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
                return $this->failureMessage("Request pattern is not valid.");
            }
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            if (!$vvsUserData->toArray()) {
                return $this->failureMessage("Token mismatch");
            }
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;

            $chartHiraTotalCount = $this->vvsChartHiraServices->getChartHiraTotalCount($requestData);
            $output["TOTAL_NO"] = $chartHiraTotalCount;

            $chartHiraByTimeCount = $this->vvsChartHiraServices->getChartHiraCountByTime($requestData);
            $chartHiraTimeStatusData = $this->setTimeStatusPieChartData($chartHiraByTimeCount);
            $output["OVERVIEW_HIRA_COUNT"] = $chartHiraTimeStatusData;

            $chartHiraJobTypeByTimeCount = $this->vvsChartHiraServices->getChartHiraActivityTypeCountByTime($requestData);
            $chartJobTimeStatusData = $this->setTypeTimeStatusBarChartData($chartHiraJobTypeByTimeCount);
            $output["TYPE_WISE_OVERVIEW_HIRA_COUNT"] = $chartJobTimeStatusData;
            //prd($chartHiraJobTypeByTimeCount);

            $chartHiraByJobCount = $this->vvsChartHiraServices->getChartActivityCountByJob($requestData);
            $chartActivityJobBarData = $this->setBarChartData($chartHiraByJobCount);
            $output["OVERALL_JOB_WISE_HIRA_COUNT"] = $chartActivityJobBarData;
            
            $chartHiraPtwByJobCount = $this->vvsChartHiraServices->getChartActivityPtwCountByJob($requestData);
            $chartActivityJobPtwBarData = $this->setBarChartData($chartHiraPtwByJobCount);
            $output["PTW_REQUIRED_JOB_WISE_HIRA_COUNT"] = $chartActivityJobPtwBarData;

            $chartHiraPtwReqCount = $this->vvsChartHiraServices->getChartActivityPtwRequiredCount($requestData);
            $chartActivityPtwReqData = $this->setPtwReqPieChartData($chartHiraPtwReqCount);
            $output["PTW_REQUIRED_OVERVIEW_HIRA_COUNT"] = $chartActivityPtwReqData;
            //prd($chartHiraPtwReqCount);

            $chartHiraRiskMatrixCount = $this->vvsChartHiraServices->getChartActivityByRiskMatrix($requestData);            
            $chartActivityRiskData = $this->setRiskMatrixPieChartData($chartHiraRiskMatrixCount);
            $output["RISK_RATING_OVERVIEW_HIRA_COUNT"] = $chartActivityRiskData;
            
            $chartHiraRiskMatrixCountByJob = $this->vvsChartHiraServices->getChartActivityRiskCountByType($requestData);
            $chartHiraRiskDatabByType = $this->setRiskMatrixBarChartData($chartHiraRiskMatrixCountByJob);
            $output["TYPE_WISE_RISK_RATING_ACTIVITY_COUNT"] = $chartHiraRiskDatabByType;
            //prd($chartHiraRiskMatrixCountByJob);

            return $this->successMessage($output);
            
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    private function setBarChartData($barChartData){
        $barChartArr = array();
        if(!empty($barChartData)){
            foreach ($barChartData as $key => $value) {
                $barChartArr['labels'][] = $value->JOB_NAME;
                $barChartArr['data'][] = $value->HIRA_COUNT??0;
            }
        }
        
        $returnset['labels'] = $barChartArr['labels'];
        $returnset['datasets'][0]['data'] = $barChartArr['data'];
        $returnset['datasets'][0]['backgroundColor'] = '#e60000';
        $returnset['datasets'][0]['hoverBackgroundColor'] = '#e60000';
        $returnset['datasets'][0]['barThickness'] = 8;

        return $returnset;
    }

    private function setPtwReqPieChartData($pieChartData){
        $pieChartArr = array();
        $pieChartArr['data'][1]=0;
        $pieChartArr['data'][2]=0;
        if(!empty($pieChartData)){
            foreach ($pieChartData as $key => $value) {
                $pieChartArr['data'][$value->IS_PTW_REQUIRED]+= $value->hira_count??0;
            }
        }
        
        $returnset['labels'] = ['PTW Required','PTW Not Required'];
        $returnset['datasets'][0]['data'] = [$pieChartArr['data'][1],$pieChartArr['data'][2]];
        $returnset['datasets'][0]['backgroundColor'] = ['#c4c7c9', '#333333', '#e60000'];
        $returnset['datasets'][0]['hoverBackgroundColor'] = ['#c4c7c9', '#333333', '#e60000'];
        //$returnset['datasets'][0]['barThickness'] = 8;

        return $returnset;
    }

    private function setRiskMatrixPieChartData($pieChartData){
        $pieChartArr = array();
        $pieChartArr['data'][0]=0;
        $pieChartArr['data'][1]=0;
        $pieChartArr['data'][2]=0;
        if(!empty($pieChartData)){
            foreach ($pieChartData as $key => $value) {
                if(strtoupper($value->risk_factor) == "A1" || strtoupper($value->risk_factor) == "A2" || strtoupper($value->risk_factor) == "B1"){
                    $pieChartArr['data'][0]+=$value->HIRA_ACTIVITY_COUNT??0;
                }elseif(strtoupper($value->risk_factor) == "A3" || strtoupper($value->risk_factor) == "B2" || strtoupper($value->risk_factor) == "C1"){
                    $pieChartArr['data'][1]+=$value->HIRA_ACTIVITY_COUNT??0;
                }elseif(strtoupper($value->risk_factor) == "B3" || strtoupper($value->risk_factor) == "C2" || strtoupper($value->risk_factor) == "C3"){
                    $pieChartArr['data'][2]+=$value->HIRA_ACTIVITY_COUNT??0;
                }
            }
        }
        
        $returnset['labels'] = ['High','Medium','Low'];
        $returnset['datasets'][0]['data'] = $pieChartArr['data'];
        $returnset['datasets'][0]['backgroundColor'] = ['#c4c7c9', '#333333', '#e60000'];
        $returnset['datasets'][0]['hoverBackgroundColor'] = ['#c4c7c9', '#333333', '#e60000'];
        //$returnset['datasets'][0]['barThickness'] = 8;

        return $returnset;
    }

    private function setRiskMatrixBarChartData($pieChartData){
        $barChartArr = array();
        $labelArr = array();
        if(!empty($pieChartData)){
            foreach ($pieChartData as $key => $value) {
                $barChartArr[$value->JOB_ID]['labels'] = $value->JOB_NAME;
                $barChartArr[$value->JOB_ID]['high'][] = 0;
                $barChartArr[$value->JOB_ID]['medium'][] = 0;
                $barChartArr[$value->JOB_ID]['low'][] = 0;
                if(strtoupper($value->RISK_FACTOR) == "A1" || strtoupper($value->RISK_FACTOR) == "A2" || strtoupper($value->RISK_FACTOR) == "B1"){
                    $barChartArr[$value->JOB_ID]['high'][]=$value->HIRA_COUNT??0;
                }elseif(strtoupper($value->RISK_FACTOR) == "A3" || strtoupper($value->RISK_FACTOR) == "B2" || strtoupper($value->RISK_FACTOR) == "C1"){
                    $barChartArr[$value->JOB_ID]['medium'][]=$value->HIRA_COUNT??0;
                }elseif(strtoupper($value->RISK_FACTOR) == "B3" || strtoupper($value->RISK_FACTOR) == "C2" || strtoupper($value->RISK_FACTOR) == "C3"){
                    $barChartArr[$value->JOB_ID]['low'][]=$value->HIRA_COUNT??0;
                }
            }
        }
        foreach ($barChartArr as $key => $value) {
            $labelArr['labels'][] = $value['labels'];
            $labelArr['high'][] = array_sum($value['high']);
            $labelArr['medium'][] = array_sum($value['medium']);
            $labelArr['low'][] = array_sum($value['low']);
        }
        $hghArray['data'] = $labelArr['high'];
        $hghArray['label'] = 'High';
        $hghArray['backgroundColor'] = ['#e60800'];
        $hghArray['hoverBackgroundColor'] = ['#e60800'];
        $hghArray['barThickness'] = 8;
        $hghArray['stack'] = 'a';

        $mediumArray['data'] = $labelArr['medium'];
        $mediumArray['label'] = 'Medium';
        $mediumArray['backgroundColor'] = ['#333333'];
        $mediumArray['hoverBackgroundColor'] = ['#333333'];
        $mediumArray['barThickness'] = 8;
        $mediumArray['stack'] = 'a';

        $lowArray['data'] = $labelArr['low'];
        $lowArray['label'] = 'Low';
        $lowArray['backgroundColor'] = ['#808080'];
        $lowArray['hoverBackgroundColor'] = ['#808080'];
        $lowArray['barThickness'] = 8;
        $lowArray['stack'] = 'a';

        
        $returnset['labels'] = $labelArr['labels'];
        $returnset['datasets'][] = $lowArray;
        $returnset['datasets'][] = $mediumArray;
        $returnset['datasets'][]=$hghArray;
        return $returnset;
    }


    private function setTimeStatusPieChartData($pieChartData){
        $pieChartArr = array();
        $pieChartArr['data'][0]=0;
        $pieChartArr['data'][1]=0;
        $pieChartArr['data'][2]=0;
        if(!empty($pieChartData)){
            foreach ($pieChartData as $key => $value) {
                if(strtoupper($value->hira_end_status) == 1){
                    $pieChartArr['data'][0]=$value->hira_count??0;
                }elseif(strtoupper($value->hira_end_status) == 2){
                    $pieChartArr['data'][1]=$value->hira_count??0;
                }elseif(strtoupper($value->hira_end_status) == 3){
                    $pieChartArr['data'][2]=$value->hira_count??0;
                }
            }
        }
        
        $returnset['labels'] = ['Expired','On Expiration','In a Place'];
        $returnset['datasets'][0]['data'] = $pieChartArr['data'];
        $returnset['datasets'][0]['backgroundColor'] = ['#c4c7c9', '#333333', '#e60000'];
        $returnset['datasets'][0]['hoverBackgroundColor'] = ['#c4c7c9', '#333333', '#e60000'];
        //$returnset['datasets'][0]['barThickness'] = 8;

        return $returnset;
    }

    private function setTypeTimeStatusBarChartData($pieChartData){
        $barChartArr = array();
        $labelArr = array();
        if(!empty($pieChartData)){
            foreach ($pieChartData as $key => $value) {
                $barChartArr[$value->JOB_ID]['labels'] = $value->JOB_NAME;
                $barChartArr[$value->JOB_ID]['expired'][]=0;
                $barChartArr[$value->JOB_ID]['expiring'][]=0;
                if(strtoupper($value->HIRA_END_STATUS) == 1){
                    $barChartArr[$value->JOB_ID]['expired'][]=$value->HIRA_COUNT??0;
                }elseif(strtoupper($value->HIRA_END_STATUS) == 2){
                    $barChartArr[$value->JOB_ID]['expiring'][]=$value->HIRA_COUNT??0;
                }
            }
        }
        foreach ($barChartArr as $key => $value) {
            $labelArr['labels'][] = $value['labels'];
            $labelArr['expired'][] = array_sum($value['expired']);
            $labelArr['expiring'][] = array_sum($value['expiring']);
        }
        $expiredArray['data'] = $labelArr['expired'];
        $expiredArray['label'] = 'Expired';
        $expiredArray['backgroundColor'] = ['#e60800'];
        $expiredArray['hoverBackgroundColor'] = ['#e60800'];
        $expiredArray['barThickness'] = 8;
        $expiredArray['stack'] = 'a';

        $expiringArray['data'] = $labelArr['expiring'];
        $expiringArray['label'] = 'Expiring';
        $expiringArray['backgroundColor'] = ['#333333'];
        $expiringArray['hoverBackgroundColor'] = ['#333333'];
        $expiringArray['barThickness'] = 8;
        $expiringArray['stack'] = 'a';

        $returnset['labels'] = $labelArr['labels'];
        $returnset['datasets'][] = $expiredArray;
        $returnset['datasets'][] = $expiringArray;
        return $returnset;
    }
}