<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Config;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        
        $this->app->bind(
            'App\Repositories\PTW\PtwInterface',
            'App\Repositories\PTW\PtwRepository'
        );
        $this->app->bind(
            'App\Repositories\PTW\PtwMasterListInterface',
            'App\Repositories\PTW\PtwMasterListRepository'
        );
        $this->app->bind(
            'App\Repositories\Master\MasterWorkerInterface',
            'App\Repositories\Master\MasterWorkerRepository'
        );
        $this->app->bind(
            'App\Repositories\HIRA\HiraInterface',
            'App\Repositories\HIRA\HiraRepository'
        );
        $this->app->bind(
            'App\Repositories\HIRA\HiraMasterListInterface',
            'App\Repositories\HIRA\HiraMasterListRepository'
        );
        $this->app->bind(
            'App\Repositories\INSPECTION\InspectionMasterListInterface',
            'App\Repositories\INSPECTION\InspectionMasterListRepository'
        );
        $this->app->bind(
            'App\Repositories\INSPECTION\InspectionInterface',
            'App\Repositories\INSPECTION\InspectionRepository'
        );
        $this->app->bind(
            'App\Repositories\Master\MasterLocationInterface',
            'App\Repositories\Master\MasterLocationRepository'
        );
        $this->app->bind(
            'App\Repositories\OBSERVATION\ObservationMasterListInterface',
            'App\Repositories\OBSERVATION\ObservationMasterListRepository'
        );
        $this->app->bind(
            'App\Repositories\Master\MasterContractorInterface',
            'App\Repositories\Master\MasterContractorRepository'
        );
        $this->app->bind(
            'App\Repositories\OBSERVATION\ObservationInterface',
            'App\Repositories\OBSERVATION\ObservationRepository'
        );
        $this->app->bind(
            'App\Repositories\Master\MasterSkillInterface',
            'App\Repositories\Master\MasterSkillRepository'
        );
        $this->app->bind(
            'App\Repositories\Master\MasterSOPPolicyInterface',
            'App\Repositories\Master\MasterSOPPolicyRepository'
        );
        $this->app->bind(
            'App\Repositories\Master\MasterUserAccessInterface',
            'App\Repositories\Master\MasterUserAccessRepository'
        );

        $this->app->bind(
            'App\Repositories\TRAINING\TrainingMasterListInterface',
            'App\Repositories\TRAINING\TrainingMasterListRepository'
        );

        $this->app->bind(
            'App\Repositories\TRAINING\TrainingInterface',
            'App\Repositories\TRAINING\TrainingRepository'
        );

        $this->app->bind(
            'App\Repositories\File\FileInterface',
            'App\Repositories\File\FileRepository'
        );

        $this->app->bind(
            'App\Repositories\Master\MasterJobInterface',
            'App\Repositories\Master\MasterJobRepository'
        );

        $this->app->bind(
            'App\Repositories\Master\MasterActivityInterface',
            'App\Repositories\Master\MasterActivityRepository'
        );

        $this->app->bind(
            'App\Repositories\Master\MasterRiskRelatedInterface',
            'App\Repositories\Master\MasterRiskRelatedRepository'
        );

        $this->app->bind(
            'App\Repositories\Report\ReportPtwInterface',
            'App\Repositories\Report\ReportPtwRepository'
        );

        $this->app->bind(
            'App\Repositories\Report\ReportHiraInterface',
            'App\Repositories\Report\ReportHiraRepository'
        );

        $this->app->bind(
            'App\Repositories\Report\ReportObservationInterface',
            'App\Repositories\Report\ReportObservationRepository'
        );

        $this->app->bind(
            'App\Repositories\Report\ReportInspectionInterface',
            'App\Repositories\Report\ReportInspectionRepository'
        );

        $this->app->bind(
            'App\Repositories\Master\MasterTypeTopicInterface',
            'App\Repositories\Master\MasterTypeTopicRepository'
        );

        $this->app->bind(
            'App\Repositories\Dashboard\DashboardPtwInterface',
            'App\Repositories\Dashboard\DashboardPtwRepository'
        );
        $this->app->bind(
            'App\Repositories\SAMLUSER\UserInterface',
            'App\Repositories\SAMLUSER\UserRepository'
        );

        $this->app->bind(
            'App\Repositories\Dashboard\DashboardHiraInterface',
            'App\Repositories\Dashboard\DashboardHiraRepository'
        );

        $this->app->bind(
            'App\Repositories\Dashboard\DashboardTrainingInterface',
            'App\Repositories\Dashboard\DashboardTrainingRepository'
        );

        $this->app->bind(
            'App\Repositories\Dashboard\DashboardObservationInterface',
            'App\Repositories\Dashboard\DashboardObservationRepository'
        );

        $this->app->bind(
            'App\Repositories\UserAcl\UserAclMapInterface',
            'App\Repositories\UserAcl\UserAclMapRepository'
        );
        $this->app->bind(
            'App\Repositories\Report\ReportTrainingInterface',
            'App\Repositories\Report\ReportTrainingRepository'
        );

        $this->app->bind(
            'App\Repositories\Dashboard\DashboardInspectionInterface',
            'App\Repositories\Dashboard\DashboardInspectionRepository'
        );

        $this->app->bind(
            'App\Repositories\Chart\ChartPtwInterface',
            'App\Repositories\Chart\ChartPtwRepository'
        );
        $this->app->bind(
            'App\Repositories\Chart\ChartHiraInterface',
            'App\Repositories\Chart\ChartHiraRepository'
        );
        $this->app->bind(
            'App\Repositories\Chart\ChartObservationInterface',
            'App\Repositories\Chart\ChartObservationRepository'
        );
        $this->app->bind(
            'App\Repositories\Chart\ChartInspectionInterface',
            'App\Repositories\Chart\ChartInspectionRepository'
        );
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //Config::set('database.connections.pgsql.host', decrypt(env('DB_HOST')));
        //Config::set('database.connections.pgsql.database', decrypt(env('DB_DATABASE')));
        //Config::set('database.connections.pgsql.username', decrypt(env('DB_USERNAME')));
        //Config::set('database.connections.pgsql.password', decrypt(env('DB_PASSWORD')));
    }
}
