<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use HasFactory;
    use HasFactory, Notifiable, HasApiTokens;
    protected $primaryKey = 'ID';

    protected $table = 'USERS';
    public $timestamps = false;

    public $fillable = ["EMAIL","FIRST_NAME","LAST_NAME","IS_INFO_REDUCTED","CREATED_BY","MODIFIED_BY",
                        "CREATED_ON","MODIFIED_ON","IS_ACTIVE","IS_DELETED","MANAGER_EMAIL"];
    public function roles()
    {
        return $this->hasMany(UserMapRole::class, 'USER_ID')->where('IS_DELETED', '=', 0);
    }

    public function sites()
    {
        return $this->hasMany(UserMapSite::class, 'USER_ID')->where('IS_DELETED', '=', 0);
    }

    public function ptwroles()
    {
        return $this->hasMany(UserMapRole::class, 'USER_ID')->where('IS_DELETED', '=', 0)
                    ->where('MODULE_NAME', '=', 'PTW');
    }

    public function hiraroles()
    {
        return $this->hasMany(UserMapRole::class, 'USER_ID')->where('IS_DELETED', '=', 0)
                    ->where('MODULE_NAME', '=', 'HIRA');
    }

    public function inspectionroles()
    {
        return $this->hasMany(UserMapRole::class, 'USER_ID')->where('IS_DELETED', '=', 0)
                    ->where('MODULE_NAME', '=', 'INSP');
    }

    public function masterroles()
    {
        return $this->hasMany(UserMapRole::class, 'USER_ID')->where('IS_DELETED', '=', 0)
                    ->where('MODULE_NAME', '=', 'MASTER');
    }

    public function obsroles()
    {
        return $this->hasMany(UserMapRole::class, 'USER_ID')->where('IS_DELETED', '=', 0)
                    ->where('MODULE_NAME', '=', 'OBS');
    }

    public function trroles()
    {
        return $this->hasMany(UserMapRole::class, 'USER_ID')->where('IS_DELETED', '=', 0)
                    ->where('MODULE_NAME', '=', 'TR');
    }
    
    
}
