<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TrainingMstType extends Model
{
    use HasFactory;
    protected $primaryKey = 'TR_TYPE_ID';

    protected $table = 'TR_MST_TYPE';
    public $timestamps = false;

    public $fillable = ["TR_TYPE_NAME","CREATED_BY","MODIFIED_BY","CREATED_ON","MODIFIED_ON","IS_ACTIVE","IS_DELETED","CATEGORY"];

    public function topicMappings()
    {
        return $this->hasMany(TrainingMstTopic::class, 'TR_TYPE_ID', 'TR_TYPE_ID')->where('IS_DELETED', 0);
    }
}

