<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TrainingMstTopic extends Model
{
    use HasFactory;
    protected $primaryKey = 'TR_TOPIC_ID';

    protected $table = 'TR_MST_TOPIC';
    public $timestamps = false;

    public $fillable = ["TR_TOPIC_NAME","TR_TYPE_ID","CREATED_BY","MODIFIED_BY","CREATED_ON",
                        "MODIFIED_ON","IS_ACTIVE","IS_DELETED"];
    
    public function type()
    {
        return $this->belongsTo(TrainingMstType::class, 'TR_TYPE_ID', 'TR_TYPE_ID');
    }
}
