<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TrainingMapDeclaration extends Model
{
    use HasFactory;
    protected $primaryKey = 'MAP_DECLARATION_ID';

    protected $table = 'TR_MAP_DECLARATION';
    public $timestamps = false;

    public $fillable = ["TR_ID","DECLARATION_ID","CREATED_BY","MODIFIED_BY","CREATED_ON","MODIFIED_ON"];

    public function createdby()
    {
        return $this->belongsTo(User::class, 'CREATED_BY', 'ID');
    }
}
