<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Training extends Model
{
    use HasFactory;
    protected $primaryKey = 'ID';

    protected $table = 'TRAINING';
    public $timestamps = false;

    const CREATED_AT = 'CREATED_ON';

    const UPDATED_AT = 'MODIFIED_ON';

    public $fillable = ["SITE_ID","TR_REFERENCE_NO","LOCATION_ID","TYPE_ID","TOPIC_ID","TOPIC_NAME",
                        "TR_SCHEDULED_START_DATE","TR_SCHEDULED_END_DATE","TR_START_DATE","TR_END_DATE",
                        "TRAINERS","REMARKS","STAGE_ID","CREATED_BY","MODIFIED_BY",
                        "CREATED_ON","MODIFIED_ON","IS_PLANNED"];

    public function site()
    {
        return $this->belongsTo(MstSite::class, 'SITE_ID', 'SITE_ID');
    }
                    
    public function location()
    {
        return $this->belongsTo(HiraMstLocation::class, 'LOCATION_ID', 'LOCATION_ID');
    }

    public function stage()
    {
        return $this->belongsTo(TrainingMstStage::class, 'STAGE_ID', 'STAGE_ID');
    }

    public function type()
    {
        return $this->belongsTo(TrainingMstType::class, 'TYPE_ID', 'TR_TYPE_ID');
    }

    public function topic()
    {
        return $this->belongsTo(TrainingMstTopic::class, 'TOPIC_ID', 'TR_TOPIC_ID');
    }

    public function files()
    {
        return $this->hasMany(TrainingMapFile::class, 'TR_ID')->where('IS_DELETED', 0);
    }

    public function participants()
    {
        return $this->hasMany(TrainingMapParticipant::class, 'TR_ID')->where('IS_DELETED', 0);
    }

    public function declaredby()
    {
        return $this->hasMany(TrainingMapDeclaration::class, 'TR_ID')->where('IS_DELETED', 0);
    }
}
