<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PtwMstWorker extends Model
{
    use HasFactory;
    protected $primaryKey = 'WORKER_ID';

    protected $table = 'PTW_MST_WORKERS';
    public $timestamps = false;

    public $fillable = ["SITE_ID","WORKER_NAME","WORKER_DESG_ID","WORKER_CONTRACTOR_ID",
                        "WORKER_AUTO_GEN_ID","CREATED_BY","MODIFIED_BY","CREATED_ON","MODIFIED_ON",
                        "FILE_CAPTION","FILE_NAME","IS_ACTIVE"];


    public function contractor()
    {
        return $this->belongsTo(PtwMstContractor::class, 'WORKER_CONTRACTOR_ID', 'CONTRACTOR_ID');
    }

    public function designation()
    {
        return $this->belongsTo(PtwMstWorkerDsg::class, 'WORKER_DESG_ID', 'WORKER_DESG_ID');
    }
    public function typeMappings()
    {
        return $this->hasMany(PtwTypeMapWorkers::class, 'WORKER_ID', 'WORKER_ID')->where('IS_DELETED', 0);
    }
}
