<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PtwMstContractor extends Model
{
    use HasFactory;
    protected $primaryKey = 'CONTRACTOR_ID';

    protected $table = 'PTW_MST_CONTRACTOR';
    public $timestamps = false;

    public $fillable = ["SITE_ID","CONTRACTOR_NAME","CREATED_BY","MODIFIED_BY","CREATED_ON",
                    "MODIFIED_ON","IS_ACTIVE","IS_DELETED"];

    public function site()
    {
        return $this->belongsTo(MstSite::class, 'SITE_ID', 'SITE_ID');
    }
}
