<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PtwMapWorkers extends Model
{
    use HasFactory;
    protected $primaryKey = 'MAP_WORKERS_ID';

    protected $table = 'PTW_MAP_WORKERS';
    public $timestamps = false;

    public $fillable = ["PTW_ID","WORKER_ID","CREATED_BY","MODIFIED_BY","CREATED_ON","MODIFIED_ON"];

    public function worker()
    {
        return $this->belongsTo(PtwMstWorker::class, 'WORKER_ID', 'WORKER_ID');
    }
}
