<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PtwActionHistory extends Model
{
    use HasFactory;
    protected $primaryKey = 'HISTORY_ID';

    protected $table = 'PTW_ACTION_HISTORY';
    public $timestamps = false;

    const CREATED_AT = 'CREATED_ON';

    const UPDATED_AT = 'MODIFIED_ON';

    public $fillable = ["PTW_ID","ACTION_TAKER_ID","STAGE_ID","COMMENTS","CREATED_BY","MODIFIED_BY","CREATED_ON","MODIFIED_ON"];

    public function actionTracker()
    {
        return $this->belongsTo(User::class, 'ACTION_TAKER_ID', 'ID');
    }

    public function stage()
    {
        return $this->belongsTo(PtwMstStage::class, 'STAGE_ID', 'STAGE_ID');
    }
}
