<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ObservationActionTakenDetailsLog extends Model
{    
    use HasFactory;
    protected $primaryKey = 'HISTORY_ID';

    protected $table = 'OBS_ACTION_TAKEN_DETAILS_LOG';
    public $timestamps = false;

    const CREATED_AT = 'CREATED_ON';

    const UPDATED_AT = 'MODIFIED_ON';

    public $fillable = ["OBS_ID","ACTION_TAKER_ID","STAGE_ID","COMMENTS","CREATED_BY","MODIFIED_BY","CREATED_ON","MODIFIED_ON"];

    public function actionTracker()
    {
        return $this->belongsTo(User::class, 'ACTION_TAKER_ID', 'ID');
    }

    public function stage()
    {
        return $this->belongsTo(ObservationMstStage::class, 'STAGE_ID', 'STAGE_ID');
    }
}
