<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Observation extends Model
{
    use HasFactory;
    protected $primaryKey = 'ID';

    protected $table = 'OBSERVATION';
    public $timestamps = false;

    const CREATED_AT = 'CREATED_ON';

    const UPDATED_AT = 'MODIFIED_ON';

    public $fillable = ["SITE_ID","OBSERVATION_REFERENCE_NO","LOCATION_ID","OBS_START_DATE","OBS_END_DATE",
                        "REPORTED_BY_ID","OBS_TYPE_ID","DESCRIPTION","SEVERITY_ID","LIKELIHOOD_ID","ACTION_OWNER_ID",
                        "TARGET_TIMELINE","RECOMMENDATION","ACTION_COMPLETED_DATE","ACTION_TAKEN_DETAILS","STAGE_ID",
                        "CREATED_BY","MODIFIED_BY","CREATED_ON","MODIFIED_ON","REVISE_TIMELINE"];

    public function site()
    {
        return $this->belongsTo(MstSite::class, 'SITE_ID', 'SITE_ID');
    }
                    
    public function location()
    {
        return $this->belongsTo(HiraMstLocation::class, 'LOCATION_ID', 'LOCATION_ID');
    }    
                    
    public function stage()
    {
        return $this->belongsTo(ObservationMstStage::class, 'STAGE_ID', 'STAGE_ID');
    }

    public function obstype()
    {
        return $this->belongsTo(ObservationMstType::class, 'OBS_TYPE_ID', 'OBS_TYPE_ID');
    }

    public function severity()
    {
        return $this->belongsTo(ObservationMstSeverity::class, 'SEVERITY_ID', 'SEVERITY_ID');
    }

    public function likelihood()
    {
        return $this->belongsTo(ObservationMstLikelihood::class, 'LIKELIHOOD_ID', 'LIKELIHOOD_ID');
    }

    public function reportedBy()
    {
        return $this->belongsTo(User::class, 'REPORTED_BY_ID', 'ID');
    }

    public function actionOwner()
    {
        return $this->belongsTo(User::class, 'ACTION_OWNER_ID', 'ID');
    }

    public function actionTakenFiles()
    {
        return $this->hasMany(ObservationMapFile::class, 'OBS_ID')->where('IS_DELETED', 0)->where('SECTION', 'ACTION_TAKEN');
    }

    public function observationFiles()
    {
        return $this->hasMany(ObservationMapFile::class, 'OBS_ID')->where('IS_DELETED', 0)->where('SECTION', 'OBS_FILES');
    }

    public function reportedbyhistory()
    {
        return $this->hasMany(ObservationActionHistory::class, 'OBS_ID')->where('STAGE_ID', 2)->where('IS_DELETED', 0)->latest();
    }

    public function approvedbyhistory()
    {
        return $this->hasMany(ObservationActionHistory::class, 'OBS_ID')->where('STAGE_ID', 5)->where('IS_DELETED', 0)->latest();
    }

    public function approvedbyhistory2()
    {
        return $this->hasMany(ObservationActionHistory::class, 'OBS_ID')->where('STAGE_ID', 9)->where('IS_DELETED', 0)->latest();
    }

    public function closedbyhistory()
    {
        return $this->hasMany(ObservationActionHistory::class, 'OBS_ID')->where('STAGE_ID', 8)->where('IS_DELETED', 0)->latest();
    }

    public function actionTakenLog()
    {
        return $this->hasMany(ObservationActionTakenDetailsLog::class, 'OBS_ID')->where('IS_DELETED', 0)->latest();
    }
}
