<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InspectionMstChecklist extends Model
{
    use HasFactory;
    protected $primaryKey = 'CHECKLIST_ID';

    protected $table = 'INSP_MST_CHECKLIST';
    public $timestamps = false;

    public $fillable = ["CHECKLIST_NAME","TYPE_ID","CREATED_BY","MODIFIED_BY","CREATED_ON","MODIFIED_ON"];

    public function options()
    {
        return $this->hasMany(InspectionMapChecklistOption::class, 'CHECKLIST_ID')->where('IS_DELETED', '=', 0);
    }
}
