<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InspectionMapRecipent extends Model
{
    use HasFactory;
    protected $primaryKey = 'MAP_RECIPENT_ID';

    protected $table = 'INSP_MAP_RECIPENT';
    public $timestamps = false;

    const CREATED_AT = 'CREATED_ON';

    const UPDATED_AT = 'MODIFIED_ON';

    public $fillable = ["INSP_ID","USER_ID","CREATED_BY","MODIFIED_BY","CREATED_ON","MODIFIED_ON"];

    public function recipent()
    {
        return $this->belongsTo(User::class, 'USER_ID', 'ID');
    }
}
