<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InspectionMapChecklistOption extends Model
{
    use HasFactory;
    protected $primaryKey = 'MAP_CHECKLIST_OPTION_ID';

    protected $table = 'INSP_MAP_CHECKLIST_OPTION';
    public $timestamps = false;

    public $fillable = ["CHECKLIST_ID","CHECKLIST_OPTION_ID","CREATED_BY","MODIFIED_BY","CREATED_ON","MODIFIED_ON"];

    public function option()
    {
        return $this->belongsTo(InspectionMstChecklistOption::class, 'CHECKLIST_OPTION_ID', 'CHECKLIST_OPTION_ID');
    }
}
