<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InspectionMapChecklist extends Model
{
    use HasFactory;
    protected $primaryKey = 'MAP_CHECKLIST_ID';

    protected $table = 'INSP_MAP_CHECKLIST';
    public $timestamps = false;

    public $fillable = ["INSPECTION_ID","CHECKLIST_ID","OPTION_ID","CHECKLIST_NAME","OPTION_NAME","REMARKS","CREATED_BY","MODIFIED_BY","CREATED_ON","MODIFIED_ON"];

    public function checklist()
    {
        return $this->belongsTo(InspectionMstChecklist::class, 'CHECKLIST_ID', 'CHECKLIST_ID');
    }
}
