<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Inspection extends Model
{
    use HasFactory;
    protected $primaryKey = 'ID';

    protected $table = 'INSP';
    public $timestamps = false;

    const CREATED_AT = 'CREATED_ON';

    const UPDATED_AT = 'MODIFIED_ON';

    public $fillable = ["SITE_ID","INSPECTION_REFERENCE_NO","LOCATION_ID","TYPE_ID",
                        "INSP_DATE","DESCRIPTION","STAGE_ID","CREATED_BY","MODIFIED_BY",
                        "CREATED_ON","MODIFIED_ON"];

    public function site()
    {
        return $this->belongsTo(MstSite::class, 'SITE_ID', 'SITE_ID');
    }
                    
    public function location()
    {
        return $this->belongsTo(HiraMstLocation::class, 'LOCATION_ID', 'LOCATION_ID');
    }    
                    
    public function stage()
    {
        return $this->belongsTo(InspectionMstStage::class, 'STAGE_ID', 'STAGE_ID');
    }

    public function type()
    {
        return $this->belongsTo(InspectionMstType::class, 'TYPE_ID', 'INSP_TYPE_ID');
    }

    public function files()
    {
        return $this->hasMany(InspectionMapFiles::class, 'INSP_ID')->where('IS_DELETED', 0);
    }

    public function mapRecipent()
    {
        return $this->hasMany(InspectionMapRecipent::class, 'INSP_ID')->where('IS_DELETED', 0);
    }

    public function draftedby(){
        return $this->belongsTo(User::class, 'CREATED_BY', 'ID');
    }

    public function reportedby(){
        return $this->hasMany(InspectionActionHistory::class, 'INSPECTION_ID')->where('STAGE_ID', 2)->where('IS_DELETED', 0)->latest();
    }

    public function actionDraftedHistory()
    {
        return $this->hasMany(InspectionActionHistory::class, 'INSPECTION_ID')->where('STAGE_ID', 1)->where('IS_DELETED', 0)->latest();
    }

    public function actionReportedHistory()
    {
        return $this->hasMany(InspectionActionHistory::class, 'INSPECTION_ID')->where('STAGE_ID', 2)->where('IS_DELETED', 0)->latest();
    }
}
