<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HiraMstRiskRelated extends Model
{
    use HasFactory;
    protected $primaryKey = 'RISK_RELATED_ID';

    protected $table = 'HIRA_MST_RISK_RELATED';
    public $timestamps = false;

    const CREATED_AT = 'CREATED_ON';

    const UPDATED_AT = 'MODIFIED_ON';

    public $fillable = ["ACTIVITY_ID","RISK_RELATED_NAME","CREATED_BY","MODIFIED_BY","CREATED_ON","MODIFIED_ON"];

    public function activity()
    {
        return $this->belongsTo(HiraMstActivity::class, 'ACTIVITY_ID', 'ACTIVITY_ID');
    }
}
