<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HiraMstLocation extends Model
{
    use HasFactory;
    protected $primaryKey = 'LOCATION_ID';

    protected $table = 'HIRA_MST_LOCATION';
    public $timestamps = false;

    public $fillable = ["LOCATION_NAME","SITE_ID","BUILDING","FLOOR","WING","DEPARTMENT",
                "CHECKLIST","ASSIGNED_DEPT","QR_CODE","CREATED_BY","MODIFIED_BY","CREATED_ON","MODIFIED_ON",
                "IS_ACTIVE","IS_DELETED","LOCATION_ALIAS"];

    public function site()
    {
        return $this->belongsTo(MstSite::class, 'SITE_ID', 'SITE_ID');
    }
}
