<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HiraMstActivity extends Model
{
    use HasFactory;
    protected $primaryKey = 'ACTIVITY_ID';

    protected $table = 'HIRA_MST_ACTIVITY';
    public $timestamps = false;

    const CREATED_AT = 'CREATED_ON';

    const UPDATED_AT = 'MODIFIED_ON';

    public $fillable = ["JOB_ID","ACTIVITY_NAME","CREATED_BY","MODIFIED_BY","CREATED_ON",
                    "MODIFIED_ON","IS_ACTIVE","IS_DELETED"];

    public function job()
    {
        return $this->belongsTo(HiraMstJob::class, 'JOB_ID', 'JOB_ID');
    }
}
