<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HiraMapControlInPlace extends Model
{
    use HasFactory;
    protected $primaryKey = 'CONTROL_IN_PLACE_ID';

    protected $table = 'HIRA_MAP_CONTROL_IN_PLACE';
    public $timestamps = false;

    const CREATED_AT = 'CREATED_ON';

    const UPDATED_AT = 'MODIFIED_ON';

    public $fillable = ["HIRA_ID","CONTROL_IN_PLACE_NAME","CREATED_BY","MODIFIED_BY","CREATED_ON","MODIFIED_ON"];

    public function hira()
    {
        return $this->belongsTo(Hira::class, 'HIRA_ID', 'ID');
    }
}
