<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HiraMapActivityType extends Model
{
    use HasFactory;
    protected $primaryKey = 'ACTIVITY_TASK_ID';

    protected $table = 'HIRA_MAP_ACTIVITY_TYPE';
    public $timestamps = false;

    const CREATED_AT = 'CREATED_ON';

    const UPDATED_AT = 'MODIFIED_ON';

    public $fillable = ["HIRA_ID","ACTIVITY_ID","MST_ACTIVITY_TYPE_ID", "CREATED_BY","MODIFIED_BY","CREATED_ON","MODIFIED_ON"];

    public function activity()
    {
        return $this->belongsTo(HiraMstActivity::class, 'MST_ACTIVITY_TYPE_ID', 'ACTIVITY_ID');
    }
}
