<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HiraActivity extends Model
{
    use HasFactory;
    protected $primaryKey = 'ID';

    protected $table = 'HIRA_ACTIVITY';
    public $timestamps = false;

    const CREATED_AT = 'CREATED_ON';

    const UPDATED_AT = 'MODIFIED_ON';

    public $fillable = ["HIRA_ID","JOB_ID","ACTIVITY_ID","RISK_RELATED_ID","DESCRIPTION",
                        "IS_PTW_REQUIRED","PTW_TYPE_ID","SEVERITY_ID","LIKELIHOOD_ID","ADDTNL_CONTROL_MEASURE",
                        "ACTION_OWNER_ID","STAGE_ID","CREATED_BY","MODIFIED_BY","CREATED_ON","MODIFIED_ON","ACM_REMARKS",
                        "IS_ACTIVE","IS_DELETED","ORD_BY_SEVERITY"];
    
    
    

    public function hira()
    {
        return $this->belongsTo(Hira::class, 'HIRA_ID', 'ID');
    }

    public function job()
    {
        return $this->belongsTo(HiraMstJob::class, 'JOB_ID', 'JOB_ID');
    }

    public function riskrelated()
    {
        return $this->belongsTo(HiraMstRiskRelated::class, 'RISK_RELATED_ID', 'RISK_RELATED_ID');
    }

    public function severity()
    {
        return $this->belongsTo(HiraMstSeverity::class, 'SEVERITY_ID', 'SEVERITY_ID');
    }

    public function likelihood()
    {
        return $this->belongsTo(HiraMstLikelihood::class, 'LIKELIHOOD_ID', 'LIKELIHOOD_ID');
    }
    

    public function ptwtype()
    {
        return $this->belongsTo(PtwMstType::class, 'PTW_TYPE_ID', 'TYPE_ID');
    }

    public function controlinplaces()
    {
        return $this->hasMany(HiraMapControlInPlace::class, 'ACTIVITY_ID')->where('IS_DELETED', 0);
    }

    public function refdocs()
    {
        return $this->hasMany(HiraMapRefDoc::class, 'ACTIVITY_ID')->where('IS_DELETED', 0);
    }

    public function activitytype()
    {
        return $this->hasMany(HiraMapActivityType::class, 'ACTIVITY_ID')->where('IS_DELETED', 0);
    }

    public function actionOwner()
    {
        return $this->belongsTo(User::class, 'ACTION_OWNER_ID', 'ID');
    }
}
