<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HiraActionHistory extends Model
{
    use HasFactory;
    protected $primaryKey = 'HISTORY_ID';

    protected $table = 'HIRA_ACTION_HISTORY';
    public $timestamps = false;

    const CREATED_AT = 'CREATED_ON';

    const UPDATED_AT = 'MODIFIED_ON';

    public $fillable = ["HIRA_ID","ACTION_TAKER_ID","STAGE_ID","COMMENTS","CREATED_BY","MODIFIED_BY",
                        "CREATED_ON","MODIFIED_ON"];

    public function actionTracker()
    {
        return $this->belongsTo(User::class, 'ACTION_TAKER_ID', 'ID');
    }
                    
    public function stage()
    {
        return $this->belongsTo(HiraMstStage::class, 'STAGE_ID', 'STAGE_ID');
    }
}
