<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Hira extends Model
{
    use HasFactory;
    protected $primaryKey = 'ID';

    protected $table = 'HIRA';
    public $timestamps = false;

    const CREATED_AT = 'CREATED_ON';

    const UPDATED_AT = 'MODIFIED_ON';

    public $fillable = ["SITE_ID","RENEWAL_COUNT","HIRA_REFERENCE_NO","LOCATION_ID","TITLE",
                        "HIRA_START_DATE","HIRA_END_DATE","STAGE_ID","CREATED_BY","MODIFIED_BY",
                        "CREATED_ON","MODIFIED_ON","TOP_PARENT_HIRA_ID","PARENT_HIRA_ID"];

    public function site()
    {
        return $this->belongsTo(MstSite::class, 'SITE_ID', 'SITE_ID');
    }

    public function location()
    {
        return $this->belongsTo(HiraMstLocation::class, 'LOCATION_ID', 'LOCATION_ID');
    }    

    public function stage()
    {
        return $this->belongsTo(HiraMstStage::class, 'STAGE_ID', 'STAGE_ID');
    }

    public function hiraactives()
    {
        return $this->hasMany(HiraActivity::class, 'HIRA_ID')->where('IS_DELETED', 0);
    }

    public function refdocs()
    {
        return $this->hasMany(HiraMapRefDoc::class, 'HIRA_ID')->where('IS_DELETED', 0);
    }

    public function controlinplaces()
    {
        return $this->hasMany(HiraMapControlInPlace::class, 'HIRA_ID')->where('IS_DELETED', 0);
    }

    public function activities()
    {
        return $this->hasMany(HiraActivity::class, 'HIRA_ID')->where('IS_DELETED', 0);
    }

    public function preparedby(){
        return $this->belongsTo(User::class, 'CREATED_BY', 'ID');
    }

    public function approvedby(){
        return $this->hasMany(HiraActionHistory::class, 'HIRA_ID')->where('STAGE_ID', 5)->where('IS_DELETED', 0)->latest();
    }

    public function reviewedby(){
        return $this->hasMany(HiraActionHistory::class, 'HIRA_ID')->where('STAGE_ID', 3)->where('IS_DELETED', 0)->latest();
    }

    public function renewedhira()
    {
        return $this->hasMany(Hira::class, 'TOP_PARENT_HIRA_ID')->where('IS_DELETED', 0);
    }

    public function sendbackedby(){
        return $this->hasMany(HiraActionHistory::class, 'HIRA_ID')->where('STAGE_ID', 6)->where('IS_DELETED', 0)->latest();
    }

    public function sendbackedInitiatorby(){
        return $this->hasMany(HiraActionHistory::class, 'HIRA_ID')->where('STAGE_ID', 4)->where('IS_DELETED', 0)->latest();
    }

    public function revisedby(){
        return $this->hasMany(HiraActionHistory::class, 'HIRA_ID')->where('STAGE_ID', 7)->where('IS_DELETED', 0)->latest();
    }

    public function renewedby(){
        return $this->hasMany(HiraActionHistory::class, 'HIRA_ID')->where('STAGE_ID', 9)->where('IS_DELETED', 0)->latest();
    }

    public function parent()
    {
        return $this->belongsTo(Hira::class, 'PARENT_HIRA_ID', 'ID');
    }

    public function topParent()
    {
        return $this->belongsTo(Hira::class, 'TOP_PARENT_HIRA_ID', 'ID');
    }

}
