<?php

namespace App\Http\Traits;

trait EncDecService
{

    public function customEncrypt($req)
    {
        $encryptionKey = env("ENCRYTION_KEY");
        $salt = base64_decode(env("BASE64_DECODE_KEY"));
        $iterations = 1000;
        $keyAndIv = hash_pbkdf2('sha1', $encryptionKey, $salt, $iterations, (256 / 8) + (128 / 8), true);
        $hexKeyAndIv = bin2hex($keyAndIv);
        $key = hex2bin(substr($hexKeyAndIv, 0, 64));
        $iv = hex2bin(substr($hexKeyAndIv, 64));

        $encryptedStr = openssl_encrypt(json_encode($req), 'aes-256-cbc', $key, OPENSSL_RAW_DATA, $iv);
        $encryptedStr = base64_encode($encryptedStr);

        return $encryptedStr;
    }

    public function customDecrypt($encryptedData)
    {
        $decryptionKey = env("ENCRYTION_KEY");
        $salt = base64_decode(env("BASE64_DECODE_KEY"));
        $iterations = 1000;
        $keyAndIv = hash_pbkdf2('sha1', $decryptionKey, $salt, $iterations, (256 / 8) + (128 / 8), true);
        $hexKeyAndIv = bin2hex($keyAndIv);
        $key = hex2bin(substr($hexKeyAndIv, 0, 64));
        $iv = hex2bin(substr($hexKeyAndIv, 64));
        return json_decode(openssl_decrypt(base64_decode($encryptedData), 'aes-256-cbc', $key, OPENSSL_RAW_DATA, $iv));
    }


    public function customDecrypt5($res)
    {
        $encryptionKey = env("ENCRYTION_KEY");
        $salt = base64_decode(env("BASE64_DECODE_KEY"));
        $iterations = 1000;

        $keyAndIv = hash_pbkdf2("sha1", $encryptionKey, $salt, $iterations, (256 / 32 + 128 / 32) * 2, true);
        $hexKeyAndIv = bin2hex($keyAndIv);

        $key = hex2bin(substr($hexKeyAndIv, 0, 64));
        $iv = hex2bin(substr($hexKeyAndIv, 64));

        // You might need to base64 decode the input before decrypting
        $encryptedData = base64_decode($res);

        $decryptedStr = openssl_decrypt($encryptedData, 'aes-256-cbc', $key, OPENSSL_RAW_DATA, $iv);
        return json_decode($decryptedStr, true);
    }

    function convertStringToJSON($jsonString)
    {
        // Remove newline characters and extra whitespace
        $jsonString = str_replace(["\n", "\r"], "", $jsonString);
        $jsonString = trim($jsonString);
        // Convert the cleaned JSON string to a PHP associative array
        return json_decode($jsonString, true);
    }

    function successMessage($message){
        $jsonData = [
            "ResponseCode" => config('constants.SUCCESS_RESPONSE_STATUS_CODE'),
            "Response" => $message,
        ];

        $jsonOutput = $this->customEncrypt($jsonData);
        return response()->json(["X_KEY" => $jsonOutput]);
    }

    function failureMessage($message){
        $jsonData = [
            "ResponseCode" => config('constants.FAILURE_RESPONSE_STATUS_CODE'),
            "Response" => $message,
        ];

        $jsonOutput = $this->customEncrypt($jsonData);
        return response()->json(["X_KEY" => $jsonOutput]);
    }
}
