<?php

namespace App\Http\Resources\TRAINING;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class TrainingResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            "TR_ID"      => $this->ID,
            "TR_REFERENCE_NO" => $this->TR_REFERENCE_NO,
            "TYPE"       => $this->type->TR_TYPE_NAME,
            "TOPIC_NAME" => $this->topic->TR_TOPIC_NAME,
            "LOCATION_NAME" => (isset($this->location)?$this->location->LOCATION_NAME:""),
            "TR_SCHEDULED_START_DATE" => (isset($this->TR_SCHEDULED_START_DATE)?showDate($this->TR_SCHEDULED_START_DATE, config("constants.EXCEL_DATE_FORMAT")):""),
            "TR_SCHEDULED_END_DATE"   => (isset($this->TR_SCHEDULED_END_DATE)?showDate($this->TR_SCHEDULED_END_DATE, config("constants.EXCEL_DATE_FORMAT")):""),     
            "TR_START_DATE" => (isset($this->TR_START_DATE)?showDate($this->TR_START_DATE, config("constants.EXCEL_DATE_FORMAT")):""),
            "TR_END_DATE"   => (isset($this->TR_END_DATE)?showDate($this->TR_END_DATE, config("constants.EXCEL_DATE_FORMAT")):""),     
            "MONTH"      => showDate($this->TR_START_DATE, "M"),
            "MONTH_FULL" => showDate($this->TR_START_DATE, "F"),
            "TRAINERS"   => $this->TRAINERS,
            "REMARKS"    => $this->REMARKS,
            "IS_EDIT_BTN"   => (($this->STAGE_ID == 1 && $this->CREATED_BY == $request -> CREATED_BY)?1:0),
            "IS_DELETE_BTN" => (($this->STAGE_ID == 1 && $this->CREATED_BY == $request -> CREATED_BY)?1:0),
            "IS_COMPLETED" => ($this->STAGE_ID == 2 && !empty($this->TR_END_DATE)) ? "Completed" : "Not Completed"
        ];
    }

    public static function transformTraining($trdetails, $action = null)
    {
        
         if (!isset($action)) {
            $action = "";
        }        
        $editable = $trdetails->STAGE_ID == 1 && $action !== 'view';
        $unplannedEditable = $trdetails->STAGE_ID == 1 && $trdetails->IS_PLANNED == 0 && $action !== 'view';
        
        return [
            'ID' => ["EDITABLE" => false, "VALUE" => $trdetails->ID],
            'TR_ID' => ["EDITABLE" => false, "VALUE" => $trdetails->ID],
            'SITE_ID' => ["EDITABLE" => false, "VALUE" => $trdetails->SITE_ID],
            'TR_REFERENCE_NO' => ["EDITABLE" => false, "VALUE" => $trdetails->TR_REFERENCE_NO],
            'LOCATION_ID' => ["EDITABLE" => $unplannedEditable, "VALUE" => $trdetails->LOCATION_ID],
            'TYPE_ID' => ["EDITABLE" => false, "VALUE" => $trdetails->TYPE_ID],
            'TOPIC_ID' => ["EDITABLE" => $unplannedEditable, "VALUE" => $trdetails->TOPIC_ID],
            'TOPIC_NAME' => ["EDITABLE" => $unplannedEditable, "VALUE" => $trdetails->topic->TR_TOPIC_NAME],
            'TR_SCHEDULED_START_DATE' => ["EDITABLE" => false, "VALUE" => ((isset($trdetails->TR_SCHEDULED_START_DATE))?showDate($trdetails->TR_SCHEDULED_START_DATE, config("constants.DATE_TIME_FORMAT")):"")],
            'TR_SCHEDULED_END_DATE' => ["EDITABLE" => false, "VALUE" => ((isset($trdetails->TR_SCHEDULED_END_DATE))?showDate($trdetails->TR_SCHEDULED_END_DATE, config("constants.DATE_TIME_FORMAT")):"")],
            'TR_START_DATE' => ["EDITABLE" => $editable, "VALUE" => ((isset($trdetails->TR_START_DATE))?showDate($trdetails->TR_START_DATE, config("constants.DATE_TIME_FORMAT")):"")],
            'TR_END_DATE' => ["EDITABLE" => $editable, "VALUE" => ((isset($trdetails->TR_END_DATE))?showDate($trdetails->TR_END_DATE, config("constants.DATE_TIME_FORMAT")):"")],
            'TRAINERS' => ["EDITABLE" => $editable, "VALUE" => $trdetails->TRAINERS],
            'REMARKS' => ["EDITABLE" => $editable, "VALUE" => $trdetails->REMARKS],
            'STATUS' => ["EDITABLE" => false, "VALUE" => $trdetails->stage->STAGE_NAME],
            'IS_PLANNED' => ["EDITABLE" => false, "VALUE" => $trdetails->IS_PLANNED],
            'TR_MIN_START_DATE' => ["EDITABLE" => false, "VALUE" => ((isset($trdetails->TR_SCHEDULED_START_DATE))?showDate($trdetails->TR_SCHEDULED_START_DATE, config("constants.DATE_TIME_FORMAT")):"")],
        ];
    }

    public function transformTrainingExport($vvsTrainingData, $action = null)
    {
        return [
            "TR_ID"                     => $vvsTrainingData->ID,
            "SITE_NAME"                 => $vvsTrainingData->site ? $vvsTrainingData->site->SITE_NAME : "",
            "TR_REFERENCE_NO"           => $vvsTrainingData->TR_REFERENCE_NO,
            "TYPE_NAME"                 => $vvsTrainingData->type ? $vvsTrainingData->type->TR_TYPE_NAME : "",
            "LOCATION_NAME"             => $vvsTrainingData->location ? $vvsTrainingData->location->LOCATION_NAME : "",
            "TOPIC_NAME"                => $vvsTrainingData->TOPIC_NAME,
            "TR_SCHEDULED_START_DATE"   => (isset($vvsTrainingData->TR_SCHEDULED_START_DATE)) ?
                 showDate($vvsTrainingData->TR_SCHEDULED_START_DATE, config("constants.EXCEL_DATE_FORMAT")):"",
            "TR_SCHEDULED_END_DATE"     => (isset($vvsTrainingData->TR_SCHEDULED_END_DATE)) ?
                 showDate($vvsTrainingData->TR_SCHEDULED_END_DATE, config("constants.EXCEL_DATE_FORMAT")):"",
            "TR_START_DATE"             => (isset($vvsTrainingData->TR_START_DATE)) ?
                 showDate($vvsTrainingData->TR_START_DATE, config("constants.EXCEL_DATE_FORMAT")):"",
            "TR_END_DATE"               => (isset($vvsTrainingData->TR_END_DATE)) ?
                 showDate($vvsTrainingData->TR_END_DATE, config("constants.EXCEL_DATE_FORMAT")):"",
            "TRAINERS"                  => $vvsTrainingData->TRAINERS,
            "REMARKS"                   => $vvsTrainingData->REMARKS,
            "STAGE_NAME"                => $vvsTrainingData->stage->STAGE_NAME,
            "IS_PLANNED"                => $vvsTrainingData->IS_PLANNED == 1 ? "Planned" : "Unplanned",
        ];
    }

    
}