<?php

namespace App\Http\Resources\TRAINING;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class TrainingMstTypeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'KEY' => $this->TR_TYPE_ID,
            'VALUE' => $this->TR_TYPE_NAME,

        ];
    }

    public static function TrainingTypeWithTopic($twtdetails)
    {
        $result = [];
        foreach ($twtdetails as $detail) {
            $result[] = [
                'KEY' => $detail->TR_TYPE_NAME,
                'VALUE' => $detail->topicMappings->pluck('TR_TOPIC_NAME')->toArray(),
            ];
        }
        return $result;
    }

    public static function TrainingTypeTopicMapping($ttmdetails)
    {
        $result = [];
        foreach ($ttmdetails as $detail) {
            $topicMappings = [];
            foreach ($detail->topicMappings as $topic) {
                $topicMappings[] = [
                    'KEY' => $topic->TR_TOPIC_ID,
                    'VALUE' => $topic->TR_TOPIC_NAME,
                ];
            }
            $result[] = [
                'KEY' => $detail->TR_TYPE_ID,
                'VALUE' => $detail->TR_TYPE_NAME,
                'TOPIC' => $topicMappings,
            ];
    
        }
        return $result;
    }
}
