<?php

namespace App\Http\Resources\TRAINING;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class TrainingMapParticipantResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {        
        return [
            'NAME'    => $this->NAME,
            'DESIGNATION'  => $this->DESIGNATION,
            'ORGANIZATION'  => $this->ORGANIZATION,
            'SCORE'  => $this->SCORE,
        ];
    }

    public static function transformparticipant($participant)
    {
        return [
            'NAME'          => $participant->NAME,
            'DESIGNATION'   => $participant->DESIGNATION,
            'ORGANIZATION'  => $participant->ORGANIZATION,
            'SCORE'         => $participant->SCORE,
        ];
    }

    


}
